/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import java.util.HashMap;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.publishers.JunitResultArchiver;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;
import org.mule.tools.connectivity.jenkins.client.util.StepBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.BasicXmlConfigBuilder;

public class MasterClassicXmlConfigBuilder
extends BasicXmlConfigBuilder {
    public static String buildXmlConfig(ConnectorConfiguration connector, String mavenGoal) {
        String xml = MasterClassicXmlConfigBuilder.getResourceAsString("basic-template.xml");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("GITHUB_CONFIG", connector.getGitHubConfig("master").getXmlConfig());
        valuesMap.put("GITHUB_HTTP_URL", GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put("UNZIP_MULE_SHELL_STEP", "");
        valuesMap.put("CONNECTOR_STEPS", connector.getSteps());
        valuesMap.put("CTF_BUILD_STEP", StepBuilder.classicMasterBuildStep(connector, mavenGoal).getXmlConfig());
        valuesMap.put("MAILER", connector.getMailer().getXmlConfig());
        valuesMap.put("TRIGGERS", new TimeTrigger("H 0 H/15 * *").getXmlConfig());
        valuesMap.put("JDK_VERSION", connector.getJceEnabled() != false ? "Oracle JDK 1.7 JCE" : "Oracle JDK 1.7 (latest)");
        valuesMap.put("ENABLE_JCE_STEPS", connector.getJceEnabled() != false ? StepBuilder.getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put("MULE_CONF_FOR_JCE_STEPS", "");
        valuesMap.put("PROPERTIES", connector.getParallelBuilds() != false ? "" : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put("BUILD_WRAPPERS", "");
        valuesMap.put("PUBLISHERS", new JunitResultArchiver().getXmlConfig());
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(xml);
    }
}

