/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.Bindings;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.UsernamePasswordMultiBinding;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.publishers.JunitResultArchiver;
import org.mule.tools.connectivity.jenkins.client.models.step.EnvironmentVariableInjectStep;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.PushGitHubTrigger;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;
import org.mule.tools.connectivity.jenkins.client.util.StepBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.BasicXmlConfigBuilder;

public class Mule4XmlConfigBuilder
extends BasicXmlConfigBuilder {
    private static final String COPY_EXTENSION_TO_ROOT_SHELL_CMD = "EXTENSION=$(find target -name \"*.zip\" ! -name \"*studio-plugin*\" -maxdepth 1 -exec basename {} \\;)\ncp target/$EXTENSION .\necho \"extension_filename=$WORKSPACE/$EXTENSION\" > mvn_run.properties";
    private static final String PROPERTIES_FILE_PATH = "$WORKSPACE/mvn_run.properties";
    private static final String MULE3_TEST_AGAINST_4_MVN_SETTINGS = " -Ddeploylogs=true -Ddeploymentprofile=local -Dmuledirectory=${WORKSPACE}/mule-standalone-4.0.0-M3 -Dextensionfile=${extension_filename} -Dconnector.testing.version=\"2.0.0-SNAPSHOT\"";
    private static final String CHECKOUT_DEVELOP_CMD = "git checkout develop";

    public static String buildXmlConfig(MuleVersionRetriever muleVersionRetriever, ConnectorConfiguration connector) {
        List<String> mule4xList = muleVersionRetriever.getMule4xList();
        String xml = Mule4XmlConfigBuilder.getResourceAsString("basic-template.xml");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("GITHUB_CONFIG", connector.getGitHubConfig(connector.getMule4Branch()).getXmlConfig());
        valuesMap.put("GITHUB_HTTP_URL", GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put("UNZIP_MULE_SHELL_STEP", Mule4XmlConfigBuilder.getUnzipMulesStep(mule4xList));
        valuesMap.put("CONNECTOR_STEPS", "");
        valuesMap.put("CTF_BUILD_STEP", StepBuilder.packageWithoutTestsStep().getXmlConfig() + new ShellStep(COPY_EXTENSION_TO_ROOT_SHELL_CMD).getXmlConfig() + new EnvironmentVariableInjectStep(PROPERTIES_FILE_PATH).getXmlConfig() + new ShellStep(CHECKOUT_DEVELOP_CMD).getXmlConfig() + connector.getSteps() + StepBuilder.cleanStep().getXmlConfig() + Mule4XmlConfigBuilder.getDevelopBuildSteps(connector));
        valuesMap.put("MAILER", connector.getMailer().getXmlConfig());
        valuesMap.put("TRIGGERS", new TimeTrigger("@midnight").getXmlConfig() + new PushGitHubTrigger().getXmlConfig());
        valuesMap.put("JDK_VERSION", connector.getJceEnabled() != false ? "Oracle JDK 1.8 JCE" : "Oracle JDK 8");
        valuesMap.put("ENABLE_JCE_STEPS", connector.getJceEnabled() != false ? StepBuilder.getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put("MULE_CONF_FOR_JCE_STEPS", "");
        valuesMap.put("PROPERTIES", connector.getParallelBuilds() != false ? "" : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put("BUILD_WRAPPERS", new Bindings(new UsernamePasswordMultiBinding("7709cb6e-a949-4033-950f-cd1bb38b3b65", "SONAR_USERNAME", "SONAR_PASSWORD")).getXmlConfig());
        valuesMap.put("PUBLISHERS", new JunitResultArchiver().getXmlConfig());
        return new StrSubstitutor(valuesMap).replace(xml);
    }

    private static String getUnzipMulesStep(List<String> mule4xList) {
        ArrayList steps = new ArrayList();
        mule4xList.forEach(m4Version -> steps.add(StepBuilder.unzipMuleStandaloneStep(m4Version)));
        return steps.stream().map(ShellStep::getXmlConfig).collect(Collectors.joining());
    }

    private static String getDevelopBuildSteps(ConnectorConfiguration connector) {
        ArrayList<String> stepList = new ArrayList<String>();
        if (!connector.getActiveConfigs().isEmpty()) {
            connector.getActiveConfigs().forEach(config -> stepList.add(Mule4XmlConfigBuilder.classicDevelopBuildStepWithTestsAgainstMule4(connector, connector.getTestingConfiguration(), config).getXmlConfig()));
        } else {
            stepList.add(Mule4XmlConfigBuilder.classicDevelopBuildStepWithTestsAgainstMule4(connector, connector.getTestingConfiguration()).getXmlConfig());
        }
        return stepList.stream().collect(Collectors.joining());
    }

    private static MavenStep classicDevelopBuildStepWithTestsAgainstMule4(ConnectorConfiguration connector, String mavenGoal, String activeConfig) {
        return new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + mavenGoal + " -Dactiveconfiguration=" + activeConfig + " " + connector.getTestingConfiguration() + " -Dmavenlocalrepo=/home/jenkins/.m2 -Dm2home=/opt/maven/latest" + MULE3_TEST_AGAINST_4_MVN_SETTINGS, connector.getJvmOptions());
    }

    private static MavenStep classicDevelopBuildStepWithTestsAgainstMule4(ConnectorConfiguration connector, String mavenGoal) {
        return new MavenStep(" -B org.jacoco:jacoco-maven-plugin:0.7.2.201409121644:prepare-agent " + mavenGoal + " -Dmavenlocalrepo=/home/jenkins/.m2 -Dm2home=/opt/maven/latest" + MULE3_TEST_AGAINST_4_MVN_SETTINGS, connector.getJvmOptions());
    }
}

