package org.mule.tools.connectivity.jenkins.client.models.buildwrappers;

public class StringBinding implements BuildWrapper {

    /**
     * @param credentialsId
     * @param text
     */
    public StringBinding(final String credentialsId,
            final String text) {
        super();
        this.credentialsId = credentialsId;
        this.text = text;
    }

    private String credentialsId;
    private String text;

    @Override
    public String getXmlConfig() {
        return "   <org.jenkinsci.plugins.credentialsbinding.impl.StringBinding>\n"
                + "    <credentialsId>" + credentialsId + "</credentialsId>\n"
                + "    <variable>" + text + "</variable>\n"
                + "</org.jenkinsci.plugins.credentialsbinding.impl.StringBinding>"
                ;
    }

}
