package org.mule.tools.connectivity.jenkins.client.models.step;

import org.apache.commons.lang.StringEscapeUtils;

public class MavenStep implements JenkinsStep {

    private String mavenGoal;
    private String jvmOptions;

    public String getMavenGoal() {
        return mavenGoal;
    }

    public void setMavenGoal(String mavenGoal) {
        this.mavenGoal = mavenGoal;
    }
    public String getJvmOptions() {
        return jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public MavenStep(String mavenGoal, String jvmOptions) {
        this.jvmOptions = jvmOptions;
        this.mavenGoal = mavenGoal;
    }

    public MavenStep(String mavenGoal){
        this.mavenGoal = StringEscapeUtils.escapeXml(mavenGoal);
    }

    private String getJvmOptionsXml(){
        if(jvmOptions != null){
            return "<jvmOptions>"+StringEscapeUtils.escapeXml(jvmOptions)+"</jvmOptions>\n";
        } else {
            return "";
        }
    }

    @Override
    public String getXmlConfig() {
        return "    <hudson.tasks.Maven>\n" +
                "      <targets>"+StringEscapeUtils.escapeXml(mavenGoal)+"</targets>\n" +
                "      <mavenName>(Default)</mavenName>\n" +
                getJvmOptionsXml() +
                "      <usePrivateRepository>false</usePrivateRepository>\n" +
                "    </hudson.tasks.Maven>";
    }
}
