/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.retrievers;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;

public class WebDavMuleVersionsRetriever
extends MuleVersionRetriever {
    private static final String DEFAULT_WEBDAV_URL = "https://repository-mule-connectors.forge.cloudbees.com/private/mules/";
    private String user;
    private String password;
    private String webdavUrl;
    private static Map<String, List<String>> muleList = new HashMap<String, List<String>>();
    private static WebDavMuleVersionsRetriever instance = null;
    private Logger logger = LogManager.getLogger(WebDavMuleVersionsRetriever.class);

    @Deprecated
    public static WebDavMuleVersionsRetriever getInstance(String user, String password) {
        if (instance == null) {
            instance = new WebDavMuleVersionsRetriever(user, password);
        }
        return instance;
    }

    public WebDavMuleVersionsRetriever(String user, String password) {
        this.user = user;
        this.password = password;
        this.webdavUrl = DEFAULT_WEBDAV_URL;
    }

    public WebDavMuleVersionsRetriever(String webdavUrl, String user, String password) {
        this.user = user;
        this.password = password;
        this.webdavUrl = webdavUrl;
    }

    @Override
    public List<String> getEEMule3xList(String muleMinVersion) {
        return this.getEEMule3xList().stream().filter(mule -> this.isValidMuleVersion(muleMinVersion, mule.split("-")[3])).collect(Collectors.toList());
    }

    @Override
    public List<String> getCEMule3xList() {
        return this.getMuleList().stream().filter(mule -> !this.is4xVersion((String)mule)).filter(mule -> !mule.toLowerCase().contains("enterprise")).sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> getEEMule3xList() {
        return this.getMuleList().stream().filter(mule -> !this.is4xVersion((String)mule)).filter(mule -> mule.toLowerCase().contains("enterprise")).sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> getCEMule3xList(String muleMinVersion) {
        return this.getCEMule3xList().stream().filter(mule -> this.isValidMuleVersion(muleMinVersion, mule.split("-")[2])).collect(Collectors.toList());
    }

    @Override
    public List<String> getMule4xList() {
        return this.getMuleList().stream().filter(mule -> this.is4xVersion((String)mule)).sorted().collect(Collectors.toList());
    }

    private List<String> getMuleList() {
        List resources;
        if (muleList.containsKey(this.webdavUrl)) {
            this.logger.trace("Using already retrieved Mule runtime list.");
            return muleList.get(this.webdavUrl);
        }
        try {
            Sardine sardine = SardineFactory.begin((String)this.user, (String)this.password);
            resources = sardine.getResources(this.webdavUrl);
            sardine.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem retrieving mule versions. Please check your credentials and ensure that are correct.");
        }
        List<String> muleVersionList = resources.stream().filter(res -> res.getName().endsWith(".zip") && !res.getName().startsWith("._")).map(res -> res.getName().substring(0, res.getName().length() - 4)).peek(res -> this.logger.trace("Found Mule: " + res)).collect(Collectors.toList());
        muleList.put(this.webdavUrl, muleVersionList);
        return muleVersionList;
    }

    public String getWebdavUrl() {
        return this.webdavUrl;
    }

    public void setWebdavUrl(String webdavUrl) {
        this.webdavUrl = webdavUrl;
    }
}

