package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.Bindings;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.UsernamePasswordMultiBinding;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.publishers.JunitResultArchiver;
import org.mule.tools.connectivity.jenkins.client.models.triggers.PushGitHubTrigger;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.mule.tools.connectivity.jenkins.client.JobConstants.*;
import static org.mule.tools.connectivity.jenkins.client.util.StepBuilder.*;


/**
 * Created by estebanwasinger on 10/5/15.
 */
public class DevelopClassicXmlConfigBuilder extends BasicXmlConfigBuilder {

    public static String buildXmlConfig(final ConnectorConfiguration connector) {

        String xml = getResourceAsString(BASIC_TEMPLATE_XML);

        Map<String, String> valuesMap = new HashMap<>();
        valuesMap.put(GITHUB_CONFIG, connector.getGitHubConfig(DEVELOP_BRANCH).getXmlConfig());
        valuesMap.put(GITHUB_HTTP_URL, GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put(UNZIP_MULE_SHELL_STEP, "");
        valuesMap.put(CONNECTOR_STEPS, connector.getSteps());
        valuesMap.put(CTF_BUILD_STEP, cleanStep().getXmlConfig() + getDevelopBuildSteps(connector) + deployStep(" -DaltReleaseDeploymentRepository=id::this-job-only-deploys-snapshots::non-existent-repo").getXmlConfig() + sonarStep().getXmlConfig() + newSonarStep().getXmlConfig());
        valuesMap.put(MAILER, connector.getMailer().getXmlConfig());
        valuesMap.put(TRIGGERS, new TimeTrigger(MIDNIGHT).getXmlConfig() + new PushGitHubTrigger().getXmlConfig());
        valuesMap.put(JDK_VERSION, connector.getJceEnabled() ? JDK_8_JCE : JDK_8);
        valuesMap.put(ENABLE_JCE_STEPS, connector.getJceEnabled() ? getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put(MULE_CONF_FOR_JCE_STEPS, "");
        valuesMap.put(PROPERTIES, connector.getParallelBuilds() ? StringUtils.EMPTY : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put(BUILD_WRAPPERS, new Bindings(new UsernamePasswordMultiBinding("7709cb6e-a949-4033-950f-cd1bb38b3b65", "SONAR_USERNAME", "SONAR_PASSWORD")).getXmlConfig());
        valuesMap.put(PUBLISHERS, new JunitResultArchiver().getXmlConfig());
        return new StrSubstitutor(valuesMap).replace(xml);
    }

    private static String getDevelopBuildSteps(final ConnectorConfiguration connector) {
        List<String> stepList = new ArrayList<>();
        if (!connector.getActiveConfigs().isEmpty()) {
            connector.getActiveConfigs().forEach(config -> stepList.add(classicDevelopBuildStep(connector, config).getXmlConfig()));
        } else {
            stepList.add(classicDevelopBuildStep(connector).getXmlConfig());
        }

        return stepList.stream().reduce("", String::concat);
    }

}
