/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.models.properties.JobBlocker;
import org.mule.tools.connectivity.jenkins.client.models.publishers.JunitResultArchiver;
import org.mule.tools.connectivity.jenkins.client.models.step.MavenStep;
import org.mule.tools.connectivity.jenkins.client.models.step.ShellStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.TimeTrigger;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;
import org.mule.tools.connectivity.jenkins.client.util.GithubSSHURLParser;
import org.mule.tools.connectivity.jenkins.client.util.StepBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.BasicXmlConfigBuilder;

public class MultiMuleXmlConfigBuilder
extends BasicXmlConfigBuilder {
    private static final String CLEAN_PACKAGE_DSKIP_TESTS_GOAL = "clean package -DskipTests";
    MuleVersionRetriever muleVersionRetriever;

    public MultiMuleXmlConfigBuilder(MuleVersionRetriever muleVersionRetriever) {
        this.muleVersionRetriever = muleVersionRetriever;
    }

    public String buildXmlConfig(ConnectorConfiguration connector, String branch) {
        String xml = MultiMuleXmlConfigBuilder.getResourceAsString("basic-template.xml");
        String hackStep = "";
        if (!connector.getHackStep().equals("")) {
            hackStep = new ShellStep(connector.getHackStep()).getXmlConfig();
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        String cloudHubConfig = "";
        if (connector.getCloudHubEnabled().booleanValue() && branch.contains("develop")) {
            cloudHubConfig = StepBuilder.cloudHubBuildStep(connector).getXmlConfig();
        }
        valuesMap.put("GITHUB_CONFIG", connector.getGitHubConfig(branch).getXmlConfig());
        valuesMap.put("GITHUB_HTTP_URL", GithubSSHURLParser.toHttpsURL(connector.getGitHubUrl()));
        valuesMap.put("UNZIP_MULE_SHELL_STEP", this.unzipMulesSteps(connector) + hackStep);
        valuesMap.put("CONNECTOR_STEPS", connector.getSteps());
        valuesMap.put("CTF_BUILD_STEP", this.ctfBuildSteps(connector, branch) + cloudHubConfig);
        valuesMap.put("MAILER", connector.getMailer().getXmlConfig());
        valuesMap.put("TRIGGERS", new TimeTrigger(branch.contains("develop") ? "H 0 * * 7" : "H 0 H/15 * *").getXmlConfig());
        valuesMap.put("JDK_VERSION", connector.getJceEnabled() != false ? "Oracle JDK 1.7 JCE" : "Oracle JDK 1.7 (latest)");
        valuesMap.put("ENABLE_JCE_STEPS", connector.getJceEnabled() != false ? StepBuilder.getEnableJceSteps().getXmlConfig() : "");
        valuesMap.put("MULE_CONF_FOR_JCE_STEPS", connector.getJceEnabled() != false ? StepBuilder.getUpdateMuleConfForJceEnabledJavaSteps().getXmlConfig() : "");
        valuesMap.put("PROPERTIES", connector.getParallelBuilds() != false ? "" : new JobBlocker(connector.getName() + ".*").getXmlConfig());
        valuesMap.put("BUILD_WRAPPERS", "");
        valuesMap.put("PUBLISHERS", new JunitResultArchiver().getXmlConfig());
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(xml);
    }

    private String unzipMulesSteps(ConnectorConfiguration connector) {
        String steps = "";
        for (String muleVersion : this.muleVersionRetriever.getEEMule3xList(connector.getMinMuleVersion())) {
            steps = steps.concat(StepBuilder.unzipMuleStandaloneStep(muleVersion).getXmlConfig());
        }
        if (!connector.getIsEnterprise().booleanValue()) {
            for (String muleVersion : this.muleVersionRetriever.getCEMule3xList(connector.getMinMuleVersion())) {
                steps = steps.concat(StepBuilder.unzipMuleStandaloneStep(muleVersion).getXmlConfig());
            }
        }
        return steps;
    }

    private String ctfBuildSteps(ConnectorConfiguration connector, String branch) {
        ArrayList steps = Lists.newArrayList((Object[])new MavenStep[]{new MavenStep(CLEAN_PACKAGE_DSKIP_TESTS_GOAL)});
        List<String> muleList = Stream.concat(this.muleVersionRetriever.getEEMule3xList(connector.getMinMuleVersion()).stream(), connector.getIsEnterprise() != false ? Stream.empty() : this.muleVersionRetriever.getCEMule3xList(connector.getMinMuleVersion()).stream()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(connector.getActiveConfigs())) {
            connector.getActiveConfigs().forEach(activeConfig -> muleList.forEach(muleVersion -> steps.add(StepBuilder.ctfCleanBuildStep(connector, muleVersion, branch, activeConfig))));
        } else {
            muleList.forEach(muleVersion -> steps.add(StepBuilder.ctfCleanBuildStep(connector, muleVersion, branch)));
        }
        return steps.stream().map(step -> step.getXmlConfig()).collect(Collectors.joining());
    }
}

