/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client;

import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.FolderJob;
import com.offbytwo.jenkins.model.Job;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.tools.connectivity.jenkins.client.ConnectorConfiguration;
import org.mule.tools.connectivity.jenkins.client.retrievers.MuleVersionRetriever;
import org.mule.tools.connectivity.jenkins.client.retrievers.WebDavMuleVersionsRetriever;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.DevelopClassicPullRequestBuilderXmlConfigBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.DevelopClassicXmlConfigBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.DummyXmlConfigBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.MasterClassicXmlConfigBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.Mule4XmlConfigBuilder;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.MultiMuleXmlConfigBuilder;

public class PlanBuilder {
    private static final String ENTERPRISE_CONNECTORS_VIEW = "Connectors - Premium-Select";
    private static final String COMMUNITY_CONNECTORS_VIEW = "Connectors - Community";
    private static final String INTERNAL_ERROR_URL_IS_MALFORMED_ERROR_MSG = "Internal error. URL is malformed.";
    private static final String ALL_VIEW = "All";
    private Logger logger = LogManager.getLogger(PlanBuilder.class);
    private JenkinsServer jenkinsServer;
    private MuleVersionRetriever muleVersionRetriever;
    private String user;
    private String password;
    private String email;

    public PlanBuilder(String jenkinsUrl, String user, String email, String password) {
        this.user = user;
        this.email = email;
        this.password = password;
        this.muleVersionRetriever = WebDavMuleVersionsRetriever.getInstance(user, password);
        try {
            this.jenkinsServer = new JenkinsServer(new URI(jenkinsUrl), email, password);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(INTERNAL_ERROR_URL_IS_MALFORMED_ERROR_MSG, e);
        }
    }

    public PlanBuilder(JenkinsServer jenkinsServer, MuleVersionRetriever muleVersionRetriever) {
        this.jenkinsServer = jenkinsServer;
        this.muleVersionRetriever = muleVersionRetriever;
    }

    public void createClassicPlans(ConnectorConfiguration connector) throws IOException {
        if (connector.getDevelopSupport().booleanValue()) {
            this.createDevelopClassicPlan(connector);
        }
        if (connector.getMasterSupport().booleanValue()) {
            this.createMasterClassicPlan(connector);
        }
    }

    public void createMultiMulePlans(ConnectorConfiguration connector) throws IOException {
        if (connector.getDevelopSupport().booleanValue()) {
            this.createMultiMulePlan(connector, "develop");
        }
        if (connector.getMasterSupport().booleanValue()) {
            this.createMultiMulePlan(connector, "master");
        }
    }

    public void createMule4xPlan(ConnectorConfiguration connector) throws IOException {
        String name = "mule4-" + connector.getName() + "-" + "develop";
        String viewName = "mule4";
        this.createOrUpdate(Mule4XmlConfigBuilder.buildXmlConfig(this.muleVersionRetriever, connector), name, viewName);
    }

    public void createDevelopClassicPlan(ConnectorConfiguration connector) throws IOException {
        String name = connector.getName() + "-" + "develop";
        String viewName = connector.getIsEnterprise() != false ? ENTERPRISE_CONNECTORS_VIEW : COMMUNITY_CONNECTORS_VIEW;
        String viewNamePRBuilder = "PR-Builder";
        String namePRBuilder = name + "-PR-BUILDER";
        this.createOrUpdate(DevelopClassicXmlConfigBuilder.buildXmlConfig(connector), name, viewName);
        this.createOrUpdate(DevelopClassicPullRequestBuilderXmlConfigBuilder.buildXmlConfig(connector), namePRBuilder, viewNamePRBuilder);
    }

    public void createMasterClassicPlan(ConnectorConfiguration connector) throws IOException {
        String name = connector.getName() + "-" + "master";
        String viewName = connector.getIsEnterprise() != false ? ENTERPRISE_CONNECTORS_VIEW : COMMUNITY_CONNECTORS_VIEW;
        this.createOrUpdate(MasterClassicXmlConfigBuilder.buildXmlConfig(connector), name, viewName);
    }

    public void createMultiMulePlan(ConnectorConfiguration connector, String branch) throws IOException {
        MultiMuleXmlConfigBuilder xmlConfigBuilder = new MultiMuleXmlConfigBuilder(this.muleVersionRetriever);
        String xml = xmlConfigBuilder.buildXmlConfig(connector, branch);
        String name = connector.getName() + "-multimule-" + branch;
        String viewName = connector.getIsEnterprise() != false ? ENTERPRISE_CONNECTORS_VIEW : COMMUNITY_CONNECTORS_VIEW;
        this.createOrUpdate(xml, name, viewName);
    }

    public void createOrUpdate(String xml, String name, String viewName) throws IOException {
        if (this.jenkinsServer.getJobs().get(name.toLowerCase()) == null) {
            this.jenkinsServer.createJob(name, xml, Boolean.valueOf(true));
            this.logger.info("Created: " + name);
            this.jenkinsServer.addJobToView(name, viewName, true);
        } else {
            this.logger.info("Updated: " + name);
            this.jenkinsServer.updateJob(name, xml, true);
        }
    }

    public void createOrUpdate(String xml, String name, FolderJob folderJob) throws IOException {
        if (this.jenkinsServer.getJobs().get(name.toLowerCase()) == null) {
            this.jenkinsServer.createJob(folderJob, name, xml, Boolean.valueOf(true));
            this.logger.info("Created: " + name);
        } else {
            this.logger.info("Updated: " + name);
            this.jenkinsServer.updateJob(folderJob, name, xml, true);
        }
    }

    public void createOrUpdate(String xml, String name) throws IOException {
        if (this.jenkinsServer.getJobs().get(name.toLowerCase()) == null) {
            this.jenkinsServer.createJob(name, xml, Boolean.valueOf(true));
            this.logger.info("Created: " + name);
        } else {
            this.logger.info("Updated: " + name);
            this.jenkinsServer.updateJob(name, xml, true);
        }
    }

    public void deletePlans(ConnectorConfiguration connector) throws IOException {
        List jobList = this.jenkinsServer.getView(ALL_VIEW).getJobs();
        for (Job job : jobList) {
            if (!job.getName().startsWith(connector.getName())) continue;
            this.logger.info("Deleting: " + job.getName());
            this.jenkinsServer.deleteJob(job.getName());
        }
    }

    public void createBYOCDummyPlan(ConnectorConfiguration connector) {
        DummyXmlConfigBuilder dummyXmlConfigBuilder = new DummyXmlConfigBuilder();
        dummyXmlConfigBuilder.buildXmlConfig(connector);
    }

    public void deletePlan(String jobName) throws IOException {
        this.jenkinsServer.deleteJob(jobName);
    }

    public void deletePlan(FolderJob folder, String jobName) throws IOException {
        this.jenkinsServer.deleteJob(folder, jobName);
    }
}

