package org.mule.tools.connectivity.jenkins.client.models.buildwrappers;

public class UsernamePasswordMultiBinding implements BuildWrapper {

    /**
     * @param credentialsId
     * @param usernameVariable
     * @param passwordVariable
     */
    public UsernamePasswordMultiBinding(final String credentialsId,
            final String usernameVariable, final String passwordVariable) {
        super();
        this.credentialsId = credentialsId;
        this.usernameVariable = usernameVariable;
        this.passwordVariable = passwordVariable;
    }

    private String credentialsId;
    private String usernameVariable;
    private String passwordVariable;

    @Override
    public String getXmlConfig() {
        return "   <org.jenkinsci.plugins.credentialsbinding.impl.UsernamePasswordMultiBinding>"
                + "    <credentialsId>" + credentialsId + "</credentialsId>"
                + "    <usernameVariable>" + usernameVariable + "</usernameVariable>"
                + "    <passwordVariable>" + passwordVariable + "</passwordVariable>"
                + "</org.jenkinsci.plugins.credentialsbinding.impl.UsernamePasswordMultiBinding>"
                ;
    }

}
