package org.mule.tools.connectivity.jenkins.client.models.step;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class MavenStep implements JenkinsStep {

    private String mavenGoal;
    private String jvmOptions;
    private String mavenSettingsId;

    public String getMavenGoal() {
        return mavenGoal;
    }

    public void setMavenGoal(String mavenGoal) {
        this.mavenGoal = mavenGoal;
    }
    public String getJvmOptions() {
        return jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public MavenStep(String mavenGoal, String jvmOptions) {
        this.jvmOptions = jvmOptions;
        this.mavenGoal = mavenGoal;
    }

    public MavenStep(String mavenGoal, String jvmOptions, String mavenSettingsId) {
        this.jvmOptions = jvmOptions;
        this.mavenGoal = mavenGoal;
        this.mavenSettingsId = mavenSettingsId;
    }

    public MavenStep(String mavenGoal){
        this.mavenGoal = StringEscapeUtils.escapeXml(mavenGoal);
    }

    private String getJvmOptionsXml(){
        if(jvmOptions != null){
            return "<jvmOptions>"+StringEscapeUtils.escapeXml(jvmOptions)+"</jvmOptions>\n";
        } else {
            return "";
        }
    }

    @Override
    public String getXmlConfig() {
        return "    <hudson.tasks.Maven>\n" +
                "      <targets>"+StringEscapeUtils.escapeXml(mavenGoal)+"</targets>\n" +
                "      <mavenName>(Default)</mavenName>\n" +
                getJvmOptionsXml() +
                "      <usePrivateRepository>false</usePrivateRepository>\n" +
                getConfigFileXml() +
                "    </hudson.tasks.Maven>";
    }

    protected String getConfigFileXml(){
        if(StringUtils.isNotBlank(mavenSettingsId)){
            return "<settings class=\"org.jenkinsci.plugins.configfiles.maven.job.MvnSettingsProvider\" plugin=\"config-file-provider@3.3\">\n" +
                    "  <settingsConfigId>" + mavenSettingsId + "</settingsConfigId>\n" +
                    "</settings>\n";
        }
        else {
            return "";
        }
    }
}
