/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.models.scm;

import org.apache.commons.lang.StringUtils;
import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;

public class GithubSCM
implements JenkinsModel {
    private String gitHubUrl;
    private String gitHubBranch;
    private String credentialsId;

    public String getGitHubUrl() {
        return this.gitHubUrl;
    }

    public void setGitHubUrl(String gitHubUrl) {
        this.gitHubUrl = gitHubUrl;
    }

    public String getGitHubBranch() {
        return this.gitHubBranch;
    }

    public void setGitHubBranch(String gitHubBranch) {
        this.gitHubBranch = gitHubBranch;
    }

    public GithubSCM() {
    }

    public GithubSCM(String gitHubUrl, String gitHubBranch) {
        this.gitHubUrl = gitHubUrl;
        this.gitHubBranch = gitHubBranch;
    }

    public GithubSCM(String gitHubUrl, String gitHubBranch, String credentialsId) {
        this.gitHubUrl = gitHubUrl;
        this.gitHubBranch = gitHubBranch;
        this.credentialsId = credentialsId;
    }

    private String getCredentials() {
        if (StringUtils.isNotEmpty((String)this.credentialsId)) {
            return "        <credentialsId>" + this.credentialsId + "</credentialsId>";
        }
        return "";
    }

    @Override
    public String getXmlConfig() {
        return "<scm class=\"hudson.plugins.git.GitSCM\" plugin=\"git@2.3.5\">\n    <configVersion>2</configVersion>\n    <userRemoteConfigs>\n      <hudson.plugins.git.UserRemoteConfig>\n        <url>" + this.gitHubUrl + "</url>\n" + this.getCredentials() + "      </hudson.plugins.git.UserRemoteConfig>\n    </userRemoteConfigs>\n    <branches>\n      <hudson.plugins.git.BranchSpec>\n        <name>" + this.gitHubBranch + "</name>\n      </hudson.plugins.git.BranchSpec>\n    </branches>\n    <doGenerateSubmoduleConfigurations>false</doGenerateSubmoduleConfigurations>\n    <submoduleCfg class=\"list\"/>\n    <extensions/>\n  </scm>";
    }
}

