/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.jenkins.client.xmlBuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.mule.tools.connectivity.jenkins.client.models.JenkinsModel;
import org.mule.tools.connectivity.jenkins.client.models.buildwrappers.BuildWrapper;
import org.mule.tools.connectivity.jenkins.client.models.properties.JenkinsProperty;
import org.mule.tools.connectivity.jenkins.client.models.publishers.JenkinsPublisher;
import org.mule.tools.connectivity.jenkins.client.models.scm.GithubSCM;
import org.mule.tools.connectivity.jenkins.client.models.step.JenkinsStep;
import org.mule.tools.connectivity.jenkins.client.models.triggers.JenkinsTrigger;
import org.mule.tools.connectivity.jenkins.client.xmlBuilder.BasicXmlConfigBuilder;

public class JenkinsConfigBuilder
extends BasicXmlConfigBuilder {
    private String jdkVersion = "Oracle JDK 1.7 (latest)";
    private JenkinsModel githubConfig;
    private List<JenkinsModel> stepsList = new ArrayList<JenkinsModel>();
    private List<JenkinsModel> propertiesList = new ArrayList<JenkinsModel>();
    private List<JenkinsModel> triggersList = new ArrayList<JenkinsModel>();
    private List<JenkinsModel> publisherList = new ArrayList<JenkinsModel>();
    private List<JenkinsModel> wrapperList = new ArrayList<JenkinsModel>();

    private JenkinsConfigBuilder() {
    }

    public static JenkinsConfigBuilder getJobXml(GithubSCM githubConfig) {
        JenkinsConfigBuilder jenkinsConfigBuilder = new JenkinsConfigBuilder();
        jenkinsConfigBuilder.githubConfig = githubConfig;
        return jenkinsConfigBuilder;
    }

    public JenkinsConfigBuilder withStep(JenkinsStep step) {
        this.stepsList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withProperty(JenkinsProperty step) {
        this.propertiesList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withTrigger(JenkinsTrigger step) {
        this.triggersList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withPublisher(JenkinsPublisher step) {
        this.publisherList.add(step);
        return this;
    }

    public JenkinsConfigBuilder withJdkVersion(String jdkVersion) {
        this.jdkVersion = jdkVersion;
        return this;
    }

    public JenkinsConfigBuilder withBuildWrapper(BuildWrapper step) {
        this.wrapperList.add(step);
        return this;
    }

    public String build() {
        String xml = JenkinsConfigBuilder.getResourceAsString("byoc-basic-template.xml");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("JDK_VERSION", this.jdkVersion);
        valuesMap.put("GITHUB_CONFIG", this.githubConfig.getXmlConfig());
        valuesMap.put("TRIGGERS", this.getXmlFromModelList(this.triggersList));
        valuesMap.put("PUBLISHERS", this.getXmlFromModelList(this.publisherList));
        valuesMap.put("BUILDERS", this.getXmlFromModelList(this.stepsList));
        valuesMap.put("PROPERTIES", this.getXmlFromModelList(this.propertiesList));
        valuesMap.put("BUILD_WRAPPERS", this.getXmlFromModelList(this.wrapperList));
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(xml);
    }

    private String getXmlFromModelList(List<JenkinsModel> modelList) {
        String config = "";
        for (JenkinsModel jenkinsModel : modelList) {
            config = config.concat(jenkinsModel.getXmlConfig());
        }
        return config;
    }
}

