/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.sonar.client.rest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.tools.connectivity.sonar.client.rest.client.SonarHttpClient;
import org.mule.tools.connectivity.sonar.client.rest.model.Project;
import org.mule.tools.connectivity.sonar.client.rest.model.ProjectStatus;

public class SonarRestClient {
    private static final String RESOURCES_PATH = "resources";
    public static final String ALERT_STATUS_METRIC_NAME = "alert_status";
    private SonarHttpClient client;
    private String baseUrl;

    public SonarRestClient(String baseUrl, String username, String password) {
        this.client = new SonarHttpClient(baseUrl, username, password);
        this.baseUrl = baseUrl;
    }

    public Project getProject(String projectKey) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", projectKey);
        return this.client.get(RESOURCES_PATH, params, Project.class);
    }

    public Map<String, String> getProjectMetric(String projectKey, String metric) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", projectKey);
        params.put("metrics", metric);
        Project project = this.client.get(RESOURCES_PATH, params, Project.class);
        return this.getMetric(project, metric);
    }

    private Map<String, String> getMetric(Project project, String metric) {
        Optional<Map> result = project.getMsr().stream().filter(m -> ((String)m.get("key")).equals(metric)).findFirst();
        if (!result.isPresent()) {
            throw new RuntimeException("No metric found with the given name.");
        }
        return result.get();
    }

    public List<Map<String, String>> getProjectMetrics(String projectKey, List<String> metrics) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", projectKey);
        params.put("metrics", String.join((CharSequence)",", metrics));
        Project project = this.client.get(RESOURCES_PATH, params, Project.class);
        return project.getMsr();
    }

    public ProjectStatus getProjectStatus(String projectKey) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", projectKey);
        params.put("metrics", ALERT_STATUS_METRIC_NAME);
        params.put("includealerts", "true");
        Project project = this.client.get(RESOURCES_PATH, params, Project.class);
        Map<String, String> status = this.getMetric(project, ALERT_STATUS_METRIC_NAME);
        return new ProjectStatus(status);
    }

    private String getProjectUrlFormat() {
        return this.baseUrl + "dashboard/index/%s";
    }

    public String getProjectUrl(String projectKey) {
        return String.format(this.getProjectUrlFormat(), projectKey);
    }
}

