package org.mule.tools.connectivity.sonar.client.rest.model;

import java.util.Map;

public class ProjectStatus {

    public enum Level {
        OK,
        WARN,
        ERROR;
    }

    public ProjectStatus(Map<String, String> status) {
        this.status = Level.valueOf(status.get("alert"));
        this.alertText = status.get("alert_text");
    }

    private Level status;

    private String alertText;

    public Level getStatus() {
        return status;
    }

    public void setStatus(Level status) {
        this.status = status;
    }

    public String getAlertText() {
        return alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public String getSummary() {
        switch (this.status) {
            case OK  : return "The project has passed the quality gate.";
            case WARN: return "The project has warnings on some quality gate conditions: ";
            default  : return "The project failed the quality gate.";
        }
    }

}
