/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.sonar.client.rest;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.tools.connectivity.sonar.client.rest.client.SonarHttpClient;
import org.mule.tools.connectivity.sonar.client.rest.model.Component;
import org.mule.tools.connectivity.sonar.client.rest.model.Project;
import org.mule.tools.connectivity.sonar.client.rest.model.ProjectIssueSeverity;
import org.mule.tools.connectivity.sonar.client.rest.model.ProjectIssues;
import org.mule.tools.connectivity.sonar.client.rest.model.ProjectStatus;

public class SonarRestClient {
    private static final String COMPONENT_PARAM = "component";
    private static final String MEASURES_ENDPOINT = "measures/component";
    private static final String COMPONENTS_ENDPOINT = "components/show";
    private static final String DASHBOARD_INDEX_ENDPOINT = "dashboard/index/";
    private static final String ISSUES_SEARCH_ENDPOINT = "issues/search";
    private static final String ALERT_STATUS_METRIC_NAME = "alert_status";
    private static final String METRICS_PARAM = "metricKeys";
    private static final String COMPONENT_KEYS_PARAM = "componentKeys";
    private static final String SORT_PARAM = "s";
    private static final String ASCENDING_ORDER_PARAM = "asc";
    private static final String PAGE_SIZE_PARAM = "pageSize";
    private static final String SEVERITIES_PARAM = "severities";
    private static final String RESOLVED_PARAM = "resolved";
    private SonarHttpClient client;
    private String baseUrl;

    public SonarRestClient(String baseUrl, String username, String password) {
        this.client = new SonarHttpClient(baseUrl, username, password);
        this.baseUrl = baseUrl;
    }

    public String getProjectUrl(String projectKey) {
        return this.baseUrl + DASHBOARD_INDEX_ENDPOINT + projectKey;
    }

    public Project getProject(String projectKey) throws Exception {
        return this.client.get(COMPONENTS_ENDPOINT, this.params(COMPONENT_PARAM, projectKey), Component.class).getComponent();
    }

    public List<Map<String, String>> getProjectMetrics(String projectKey, String ... metrics) throws Exception {
        Optional<Component> component = Optional.ofNullable(this.client.get(MEASURES_ENDPOINT, this.params(COMPONENT_PARAM, projectKey, METRICS_PARAM, String.join((CharSequence)",", metrics)), Component.class));
        return component.map(Component::getComponent).map(Project::getMeasures).orElseThrow(IllegalArgumentException::new);
    }

    public ProjectStatus getProjectStatus(String projectKey) throws Exception {
        Component component = this.client.get(MEASURES_ENDPOINT, this.params(COMPONENT_PARAM, projectKey, METRICS_PARAM, ALERT_STATUS_METRIC_NAME), Component.class);
        return new ProjectStatus(this.takeByKey(component.getComponent().getMeasures(), ALERT_STATUS_METRIC_NAME));
    }

    public ProjectIssues getProjectIssues(String projectKey) throws Exception {
        return this.getProjectIssues(projectKey, null, Collections.emptyList());
    }

    public ProjectIssues getProjectIssues(String projectKey, Integer maxResults) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(COMPONENT_KEYS_PARAM, projectKey);
        params.put(SORT_PARAM, "SEVERITY");
        params.put(ASCENDING_ORDER_PARAM, "false");
        params.put(RESOLVED_PARAM, "false");
        if (maxResults != null) {
            params.put(PAGE_SIZE_PARAM, maxResults.toString());
        }
        return this.client.get(ISSUES_SEARCH_ENDPOINT, params, ProjectIssues.class);
    }

    public ProjectIssues getProjectIssues(String projectKey, Integer maxResults, ProjectIssueSeverity severity) throws Exception {
        return this.getProjectIssues(projectKey, maxResults, Collections.singletonList(severity));
    }

    public ProjectIssues getProjectIssues(String projectKey, Integer maxResults, List<ProjectIssueSeverity> severities) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(COMPONENT_KEYS_PARAM, projectKey);
        params.put(SORT_PARAM, "SEVERITY");
        params.put(ASCENDING_ORDER_PARAM, "false");
        params.put(RESOLVED_PARAM, "false");
        if (severities != null && severities.size() > 0) {
            params.put(SEVERITIES_PARAM, severities.stream().map(Enum::toString).collect(Collectors.joining(",")));
        }
        if (maxResults != null) {
            params.put(PAGE_SIZE_PARAM, maxResults.toString());
        }
        return this.client.get(ISSUES_SEARCH_ENDPOINT, params, ProjectIssues.class);
    }

    private Map<String, String> params(String ... keyValuePairs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            parameters.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return parameters;
    }

    private <K, V> Map<K, V> takeByKey(List<Map<K, V>> map, K k) {
        Optional<Map> result = map.stream().filter(m -> m.get("metric").equals(k)).findFirst();
        if (!result.isPresent()) {
            throw new RuntimeException("No entry found with the given key.");
        }
        return result.get();
    }
}

