/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.connectivity.sonar.client.rest.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class SonarHttpClient {
    private CloseableHttpClient client;
    private URI uri;
    private HttpContext localContext;
    private ObjectMapper mapper;

    public SonarHttpClient(String baseUrl, String userToken, String keystorePassword, File keystore, String keystoreAlias) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        this.setUri(baseUrl);
        this.client = SonarHttpClient.addAuthentication(HttpClientBuilder.create(), userToken, keystorePassword, keystore, keystoreAlias).build();
        this.setLocalContext();
        this.setMapper();
    }

    public SonarHttpClient(String baseUrl, String user, String password) {
        this.setUri(baseUrl);
        this.client = SonarHttpClient.addAuthentication(HttpClientBuilder.create(), this.uri, user, password).build();
        this.setLocalContext();
        this.setMapper();
    }

    private void setUri(String baseUrl) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        try {
            this.uri = new URI(baseUrl + "api/");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid base URL: " + baseUrl, e);
        }
    }

    private void setLocalContext() {
        this.localContext = new BasicHttpContext();
        this.localContext.setAttribute("preemptive-auth", (Object)new BasicScheme());
    }

    private void setMapper() {
        this.mapper = this.getDefaultMapper();
    }

    static KeyStore readStore(File keystore, String keystorePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreStream, keystorePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private static HttpClientBuilder addAuthentication(HttpClientBuilder builder, String userToken, String keystorePassword, File keystore, String keystoreAlias) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        String credentials = userToken + ":";
        BasicHeader header = new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes()));
        KeyStore keyStore = SonarHttpClient.readStore(keystore, keystorePassword);
        boolean isKeystore = SonarHttpClient.containsPrivateKey(keyStore);
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (isKeystore) {
            sslContextBuilder.loadKeyMaterial(SonarHttpClient.readStore(keystore, keystorePassword), keystorePassword.toCharArray(), (alias, socket) -> keystoreAlias);
        } else {
            sslContextBuilder.loadTrustMaterial(keyStore, (chain, authType) -> true);
        }
        SSLContext sslContext = sslContextBuilder.build();
        builder.setSslcontext(sslContext);
        builder.setDefaultHeaders(Collections.singletonList(header));
        return builder;
    }

    private static HttpClientBuilder addAuthentication(HttpClientBuilder builder, URI uri, String username, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), "realm");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        provider.setCredentials(scope, (Credentials)credentials);
        builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth());
        return builder;
    }

    private static boolean containsPrivateKey(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return true;
        }
        return false;
    }

    private ObjectMapper getDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }

    public <T> List<T> getList(String path, Map<String, String> queryParams, Class<T> tClass) throws IOException, URISyntaxException {
        return (List)this.get(path, queryParams, this.getListType(tClass));
    }

    public <T> T get(String path, Map<String, String> queryParams, Class<T> tClass) throws IOException, URISyntaxException {
        return this.get(path, queryParams, this.getType(tClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T get(String path, Map<String, String> queryParams, JavaType type) throws IOException, URISyntaxException {
        URIBuilder builder = new URIBuilder(this.getPathURI(path));
        queryParams.forEach((k, v) -> builder.setParameter(k, v));
        HttpGet getMethod = new HttpGet(builder.build());
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, this.localContext);
        try {
            T t = this.objectFromResponse((HttpResponse)response, type);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    private <T> T objectFromResponse(HttpResponse response, JavaType type) throws IOException {
        InputStream content = response.getEntity().getContent();
        byte[] bytes = ByteStreams.toByteArray((InputStream)content);
        return (T)this.mapper.readValue(bytes, type);
    }

    private void releaseConnection(HttpRequestBase httpRequestBase) {
        httpRequestBase.releaseConnection();
    }

    private URI getPathURI(String path) {
        return this.uri.resolve(path);
    }

    private JavaType getListType(Class clazz) {
        return this.mapper.getTypeFactory().constructCollectionType(List.class, clazz);
    }

    private JavaType getType(Class clazz) {
        return this.mapper.getTypeFactory().constructType((Type)clazz);
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.update(authScheme, creds);
                }
            }
        }
    }
}

