package org.mule.tools.automationtestcoverage;

import org.apache.log4j.Logger;
import org.mule.tools.automationtestcoverage.inspectors.ConnectorInspector;
import org.mule.tools.automationtestcoverage.inspectors.MuleFlowInspector;
import org.mule.tools.automationtestcoverage.inspectors.TestSourcesInspector;
import org.mule.tools.automationtestcoverage.model.AutomationCoverageReport;
import org.mule.tools.automationtestcoverage.model.ConnectorProcessorInfo;
import org.mule.tools.automationtestcoverage.model.FlowInfo;
import org.mule.tools.automationtestcoverage.model.TestSourceItemInfo;
import org.mule.tools.automationtestcoverage.reports.ConnectorAutomationCoverageReport;
import org.mule.tools.automationtestcoverage.utils.Utils;

import javax.annotation.processing.*;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import java.util.List;
import java.util.Set;

@SupportedAnnotationTypes(value = { "org.mule.api.annotations.Connector" , "org.mule.api.annotations.Processor" })
@SupportedSourceVersion(SourceVersion.RELEASE_6)
@SupportedOptions(value = {})
public class ConnectorAutomationCoverageAnnotationProcessor extends AbstractProcessor {

    private Messager messager;
    private RoundEnvironment environment;
    private String projectPath;

    private Logger logger = Logger.getLogger(ConnectorAutomationCoverageAnnotationProcessor.class);


    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {

        if (annotations == null || annotations.isEmpty()) {
            return true;
        }

        projectPath = Utils.getProjectPath(processingEnv);
        messager = processingEnv.getMessager();
        environment = roundEnvironment;

        logger.info("=================================================");
        logger.info("   APT for Automation Coverage beign executed    ");
        logger.info("=================================================");

        TypeElement connectorTypeElement = null;
        TypeElement processorTypeElement = null;

        for (TypeElement connectorAnnotationType : annotations) {
            if (connectorAnnotationType.getQualifiedName().toString().equals("org.mule.api.annotations.Connector")) {
                connectorTypeElement = connectorAnnotationType;
            } else if (connectorAnnotationType.getQualifiedName().toString().equals("org.mule.api.annotations.Processor")) {
                processorTypeElement = connectorAnnotationType;
            }
        }

        assert connectorTypeElement == null : "Failed to load the type element for org.mule.api.annotations.Connector";
        assert processorTypeElement == null : "Failed to load the type element for org.mule.api.annotations.Processor";

        try {
            // Inspect connectors
            logger.info("** Inspect Connector");
            ConnectorInspector inspectConnector = new ConnectorInspector(messager, environment);
            List<String> inspectConnectors = inspectConnector.inspectConnectors(connectorTypeElement);
            // FIXME: Right now it only supports the first class annotated as @Connector, it will not process the rest of them
            String connectorXmlFlow = inspectConnectors.get(0);

            // Inspect operations
            List<ConnectorProcessorInfo> inspectedOperations = inspectConnector.inspectProcessors(processorTypeElement);

            // Inspect flows
            logger.info("** Inspect Flows");
            MuleFlowInspector muleFlowInspector = new MuleFlowInspector(messager, environment, projectPath);
            List<FlowInfo> inspectedTestResourcesForFlowOperations = muleFlowInspector.inspectTestResourcesForFlowOperations(connectorTypeElement, connectorXmlFlow);

            // Inspect java sources
            logger.info("** Inspect Test Sources");
            TestSourcesInspector testSourcesInspector = new TestSourcesInspector(messager, environment, projectPath);
            List<TestSourceItemInfo> inspectedTestSourcesForCallsToFlows = testSourcesInspector.inspectTestSourcesForCallsToFlows(connectorTypeElement, connectorXmlFlow);


            logger.info("** Export Coverage Report");
            ConnectorAutomationCoverageReport connectorAutomationCoverageReport = new ConnectorAutomationCoverageReport(messager, projectPath);
            AutomationCoverageReport generatedReport = connectorAutomationCoverageReport.generateReport(inspectedOperations, inspectedTestResourcesForFlowOperations, inspectedTestSourcesForCallsToFlows);
            connectorAutomationCoverageReport.writeReport(generatedReport);

        } catch (RuntimeException ex) {
            logger.error(ex.getMessage());
        }


        return true;
    }
}
