package org.mule.tools.automationtestcoverage.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AutomationCoverageReport {
	
	private List<AutomationCoverageReportItem> items;
	private boolean automationPassed;
	private int operations;
	private int operationsCovered;
	private int operationsUncovered;
	private int operationsSkipped;
		
	public AutomationCoverageReport() {
		super();
		items = new LinkedList<AutomationCoverageReportItem>();
		automationPassed = true;
	}
	
	public void addAutomationCoverageReportItem(AutomationCoverageReportItem item) {
		if (item != null) {
			items.add(item);
			operations ++;
			if (item.getSkippedOperation()) {
				operationsSkipped ++;
			} else if (item.getTestFilesCovered().isEmpty()) {
				operationsUncovered ++;
				automationPassed = false;
			} else {
				operationsCovered ++;
			}
		}
	}
	
	public List<AutomationCoverageReportItem> getItems() {
		return Collections.unmodifiableList(items);
	}

	public boolean getAutomationPassed() {
		return automationPassed;
	}

	public int getOperations() {
		return operations;
	}

	public int getOperationsCovered() {
		return operationsCovered;
	}

	public int getOperationsUncovered() {
		return operationsUncovered;
	}

	public int getOperationsSkipped() {
		return operationsSkipped;
	}	
}
