package org.mule.tools.automationtestcoverage.model;

import java.util.LinkedList;
import java.util.List;

public class AutomationCoverageReportItem {

    private ConnectorProcessorInfo connectorOperationInfo;
	private List<String> testFilesCovered;
	private boolean skippedOperation;
	private boolean coveredOperation;
    private boolean missingAssertion;
	private String causeOfSkip;
    private String causeOfWarning;


    public AutomationCoverageReportItem(ConnectorProcessorInfo connectorOperationInfo) {
		super();
		this.connectorOperationInfo = connectorOperationInfo;
		testFilesCovered = new LinkedList<String>();
		skippedOperation = false;
		coveredOperation = false;
        missingAssertion = false;
	}
	
	public ConnectorProcessorInfo getConnectorOperationInfo() {
		return connectorOperationInfo;
	}

	public List<String> getTestFilesCovered() {
		return testFilesCovered;
	}
	
	// FIXME: This must be readed from input params or a properties file
	public void setSkippedOperation(boolean skipOperation) {
		this.skippedOperation = skipOperation;
	}

	public boolean getSkippedOperation() {
		return skippedOperation;
	}

	public String getCauseOfSkip() {
		return causeOfSkip;
	}

	// FIXME: This must be readed from input params or a properties file
	public void setCauseOfSkip(String causeOfSkip) {
		this.causeOfSkip = causeOfSkip;
	}

    public void setCauseOfWarning(String causeOfWarning){ this.causeOfWarning = causeOfWarning; }

    public String getCauseOfWarning(){ return this.causeOfWarning; }

    public boolean isMissingAssertion() { return missingAssertion; }

    public void setMissingAssertion(boolean missingAssertion) { this.missingAssertion = missingAssertion; }

    /**
	 * Add the file path for the test that covers this operation
	 * 
	 * @param filePath The path of the file. Used only for report purposes
	 */
	public void addTestFileCovered(String filePath) {
		if (filePath != null && !filePath.isEmpty()) {
			testFilesCovered.add(filePath);
			coveredOperation = true;
		}
	}
	
	public void addTestFilesCovered(List<String> filesPath) {
		if (filesPath != null && !filesPath.isEmpty()) {
			for (String f : filesPath) {
				addTestFileCovered(f);
			}
		}
	}

	public boolean getCoveredOperation() {
		return coveredOperation;
	}


}
