package org.mule.tools.automationtestcoverage.model;

import static org.mule.tools.automationtestcoverage.utils.Utils.transformCamelCaseToXmlName;

public class ConnectorProcessorInfo {
	private String processorName;
	private String processorXmlName;

	public ConnectorProcessorInfo() {
		super();
	}
	
	public ConnectorProcessorInfo(String operationName) {
		super();
		this.processorName = operationName;
		processorXmlName = transformCamelCaseToXmlName(operationName);
	}

	public String getProcessorName() {
		return processorName;
	}

	public void setProcessorName(String processorName) {
		this.processorName = processorName;
		processorXmlName = transformCamelCaseToXmlName(processorName);
	}

	public String getProcessorXmlName() {
		return processorXmlName;
	}
}
