package org.mule.tools.automationtestcoverage.model;

import java.util.LinkedList;
import java.util.List;

public class FlowInfo {
	
	private String flowName;
	private List<String> connectorOperations;
	
	public FlowInfo() {
		super();
		this.connectorOperations = new LinkedList<String>();
	}
	
	public FlowInfo(String flowName) {
		super();
		this.flowName = flowName;
		this.connectorOperations = new LinkedList<String>();
	}

	public String getFlowName() {
		return flowName;
	}

	public void setFlowName(String flowName) {
		this.flowName = flowName;
	}

	public List<String> getConnectorOperations() {
		return connectorOperations;
	}

	public void setConnectorOperations(List<String> connectorOperations) {
		this.connectorOperations = connectorOperations;
	}
	
	public void addConnectorOperation(String operation) {
		if (operation != null && !operation.isEmpty()) {
			connectorOperations.add(operation);
		}
	}
}
