package org.mule.tools.automationtestcoverage.model;

import java.util.LinkedList;
import java.util.List;

public class TestSourceItemInfo {
	
	private String fileName;
	private List<String> flowNames;
    private List<String> assertions;
	
	public TestSourceItemInfo(String fqnClass) {
		super();
		this.fileName = fqnClass;
		flowNames = new LinkedList<String>();
		assertions = new LinkedList<String>();
	}
	
	public String getFqnClass() {
		return fileName;
	}
	
	public List<String> getFlowNames() {
		return flowNames;
	}

    public List<String> getAssertions(){ return assertions; }
	
	public void addFlowName(String flowName) {
		if (flowName != null && !flowName.isEmpty()) {
			flowNames.add(flowName);
		}
	}

    public void addAssertion(String assertion) {
        if (assertion != null && !assertion.isEmpty()) {
            assertions.add(assertion);
        }
    }
}
