package org.mule.tools.automationtestcoverage.reports;

import org.apache.log4j.Logger;
import org.mule.tools.automationtestcoverage.model.*;

import javax.annotation.processing.Messager;
import java.io.*;
import java.util.LinkedList;
import java.util.List;

public class ConnectorAutomationCoverageReport {

	static final private String reportsRelativePath = "target/reports/certification/";

	private Messager messager;
    private Logger logger = Logger.getLogger(ConnectorAutomationCoverageReport.class);

    private String projectPath;

	public ConnectorAutomationCoverageReport(Messager messager, String projectPath) {
		super();
		this.messager = messager;
		this.projectPath = projectPath;
	}

	public AutomationCoverageReport generateReport(List<ConnectorProcessorInfo> inspectedOperations, List<FlowInfo> inspectedTestResourcesForFlowOperations,
			List<TestSourceItemInfo> inspectedTestSourcesForCallsToFlows) {
		
		AutomationCoverageReport automationCoverageReport = new AutomationCoverageReport();
		
		for (ConnectorProcessorInfo opInfo : inspectedOperations) {
			AutomationCoverageReportItem automationCoverageReportItem = new AutomationCoverageReportItem(opInfo);
			List<FlowInfo> flowsCalledByOperation = inspectFlowsThatCallOperation(opInfo, inspectedTestResourcesForFlowOperations);
			List<String> inspectTestSourcesThatCallFlow = inspectTestSourcesThatCallFlow(flowsCalledByOperation, inspectedTestSourcesForCallsToFlows);
			automationCoverageReportItem.addTestFilesCovered(inspectTestSourcesThatCallFlow);
			automationCoverageReport.addAutomationCoverageReportItem(automationCoverageReportItem);
		}
		
		
		return automationCoverageReport;
	}
	
	private List<FlowInfo> inspectFlowsThatCallOperation(ConnectorProcessorInfo connectorOperationInfo, List<FlowInfo> inspectedTestResourcesForFlowOperations) {
		List<FlowInfo> lf = new LinkedList<FlowInfo>();
		
		for (FlowInfo flowInfo : inspectedTestResourcesForFlowOperations) {
			for (String flowConnectionOpeartion : flowInfo.getConnectorOperations()) {
				if (flowConnectionOpeartion.equals(connectorOperationInfo.getProcessorName()) || flowConnectionOpeartion.equals(connectorOperationInfo.getProcessorXmlName())) {
					lf.add(flowInfo);
					break;
				}
			}
		}
		
		return lf;
	}
	
	private List<String> inspectTestSourcesThatCallFlow(List<FlowInfo> flowsCalledByOperation, List<TestSourceItemInfo> inspectedTestSourcesForCallsToFlows) {
		List<String> fileNames = new LinkedList<String>();
		
		for(TestSourceItemInfo testSourceItemInfo : inspectedTestSourcesForCallsToFlows) {
			if (testSourceUseSomeFlow(testSourceItemInfo, flowsCalledByOperation)) {
				fileNames.add(testSourceItemInfo.getFqnClass());
			}
		}
		
		return fileNames;
	}
	
	private boolean testSourceUseSomeFlow(TestSourceItemInfo testSourceItemInfo, List<FlowInfo> flowsCalledByOperation) {
		if (flowsCalledByOperation != null && testSourceItemInfo.getFlowNames() != null) {
			for (FlowInfo flowInfo : flowsCalledByOperation) {
				for (String flowName : testSourceItemInfo.getFlowNames()) {
					if (flowName.equals(flowInfo.getFlowName())) {
						return true;
					}
				}
			}
		}
		
		return false;
	}
	
	public void writeReport(AutomationCoverageReport report) {
		
		final String reportFilePath = projectPath + reportsRelativePath + "automation-coverage-report.html";
		final String fileEncoding = "UTF-8";
		
		PrintWriter pw = null;
		
		try {
			File f = new File(reportFilePath);
			File fParent = f.getParentFile();
			if(!fParent.exists() && !fParent.mkdirs()){
			    throw new RuntimeException("Couldn't create dir: " + fParent);
			}
			if (!f.exists()) {
				f.createNewFile();				
			}
			pw = new PrintWriter(f, fileEncoding);
		} catch (FileNotFoundException e) {
			throw new RuntimeException("File not found in location: " + reportFilePath, e);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException("File encoding (" + fileEncoding + ") not supported", e);
		} catch (IOException e) {
			throw new RuntimeException("Can not create report file in location: " + reportFilePath, e);
		}
		
		pw.print("<!DOCTYPE html><html><head><meta charset=\"utf-8\"><meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
		pw.print("<title>Automation Coverage Report</title>");
		pw.print("<link href=\"http://netdna.bootstrapcdn.com/bootstrap/3.0.3/css/bootstrap.min.css\" rel=\"stylesheet\">");
		pw.print("<style type=\"text/css\">.container { margin-top: 10px; } .overview span { margin-right: 8px; margin-left:5px; } thead tr { color: white; background-color: black; font-weight: bold; } .inline { display: inline } </style>");
		pw.print("</head><body><div class=\"container\">");
		
		// Write body content	
		pw.print("<div class=\"overview\">");
		pw.print("<h2>General status</h2>");
		
		// If all goes well, show ok message
		if (report.getAutomationPassed()) {
			pw.print("<div class=\"alert alert-success\"><strong>Automation Coverage passed!</strong> You successfully have covered all the operations in the connector.</div>");
		} else {
			pw.print("<div class=\"alert alert-danger\"><strong>Automation coverage not passed!</strong> There are still some operations in the connector that are not covered.</div>");
		}
		
		pw.print("</div>");
		
		// Generate table of operations
		
		pw.print("<div class=\"overview\">");
		pw.print("<h2>Operations detail</h2>");
		
		pw.print("<div class=\"inline\">Total operations<span class=\"label label-default\">" + report.getOperations() + "</span></div>");
		pw.print("<div class=\"inline\">Covered<span class=\"label label-success\">" + report.getOperationsCovered() + "</span></div>");
		pw.print("<div class=\"inline\">Skipped<span class=\"label label-warning\">" + report.getOperationsSkipped() + "</span></div>");
		pw.print("<div class=\"inline\">Uncovered<span class=\"label label-danger\">" + report.getOperationsUncovered() + "</span></div>");
		
		pw.print("<table class=\"table\"><thead><tr><td>Operation Name</td><td>Covered in class</td></tr></thead><tbody>");

		
		for (AutomationCoverageReportItem item : report.getItems()) {
			pw.print("<tr class=\"");
			// Change the class style based on the state of the coverage ( skipped | covered | uncovered )
			pw.print(item.getSkippedOperation() ? "alert-warning" : (item.getCoveredOperation() ? "alert-success" : "alert-danger"));
			pw.print("\">");
			pw.print("<td>" + item.getConnectorOperationInfo().getProcessorName() + "</td>");
			pw.print("<td><ul>");
			for (String file : item.getTestFilesCovered()) {
				pw.print("<li>" + file + "</li>");
			}
			pw.print("</ul></td></tr>");
		}
		
		pw.print("</tbody></table></div>");		
		pw.print("</div></body></html>");
		pw.close();
	}
}
