package org.mule.tools.automationtestcoverage.utils;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic.Kind;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
	
	static final private Pattern camelCaseToMuleXmlPattern = Pattern.compile("([A-Z0-9])");
	static final private Pattern generatePathToProjectPathPattern = Pattern.compile("(.*)target/?.*");
	
	static public String transformCamelCaseToXmlName(String camelName) {
		if (camelName == null || camelName.isEmpty()) {
			return null;
		}
		
		Matcher matcher = camelCaseToMuleXmlPattern.matcher(camelName);
		StringBuffer sb = new StringBuffer();		
		
		while (matcher.find()) {
			matcher.appendReplacement(sb, "-" + matcher.group(1).toLowerCase());
		}
		
		matcher.appendTail(sb);
		
		return sb.toString();
	}
	
	static public String transformGeneratePathToProjectPath(String generatePath) {
		String path = null;
		
		Matcher m = generatePathToProjectPathPattern.matcher(generatePath);
		
		if (m.find()) {
			path = m.group(1);
		}		
		
		return path;
	}
	
	static public void throwError(Messager messager, String errorMsg) {
		messager.printMessage(Kind.ERROR, errorMsg);
		throw new RuntimeException(errorMsg);
	}

    static public String getProjectPath(ProcessingEnvironment processingEnv) {
        String projectPath = null;
		/*
		 * From the SOURCE_OUTPUT path get the project root folder
		 *
		 * Note: SOURCE_PATH during the eclipse plugin debug is returning an exception. The only value that returns something is SOURCE_OUTPUT, so i will
		 *       get the project path from this
		 */
        try {

            FileObject resource2 = processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "temp");
            File temp = new File(resource2.toUri().getPath());
            projectPath = Utils.transformGeneratePathToProjectPath(temp.getAbsolutePath());
            temp.delete();

        } catch (Throwable e1) {
            throwError(processingEnv.getMessager(), "Cannot locate the project path");
        }

        return projectPath;
    }
	
	static public String getRelativePath(String projectPath, String filePath) {
		return filePath.replace(projectPath, "");
	}
}
