/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.automationtestcoverage;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.apache.log4j.Logger;
import org.mule.tools.automationtestcoverage.inspectors.ConnectorInspector;
import org.mule.tools.automationtestcoverage.inspectors.MuleFlowInspector;
import org.mule.tools.automationtestcoverage.inspectors.TestSourcesInspector;
import org.mule.tools.automationtestcoverage.model.AutomationCoverageReport;
import org.mule.tools.automationtestcoverage.model.ConnectorProcessorInfo;
import org.mule.tools.automationtestcoverage.model.FlowInfo;
import org.mule.tools.automationtestcoverage.model.TestSourceItemInfo;
import org.mule.tools.automationtestcoverage.reports.ConnectorAutomationCoverageReport;
import org.mule.tools.automationtestcoverage.utils.Utils;

@SupportedAnnotationTypes(value={"org.mule.api.annotations.Connector", "org.mule.api.annotations.Processor"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={})
public class ConnectorAutomationCoverageAnnotationProcessor
extends AbstractProcessor {
    private Messager messager;
    private RoundEnvironment environment;
    private String projectPath;
    private Logger logger = Logger.getLogger(ConnectorAutomationCoverageAnnotationProcessor.class);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (annotations == null || annotations.isEmpty()) {
            return true;
        }
        this.projectPath = Utils.getProjectPath(this.processingEnv);
        this.messager = this.processingEnv.getMessager();
        this.environment = roundEnvironment;
        this.logger.info((Object)"=================================================");
        this.logger.info((Object)"   APT for Automation Coverage beign executed    ");
        this.logger.info((Object)"=================================================");
        TypeElement connectorTypeElement = null;
        TypeElement processorTypeElement = null;
        for (TypeElement typeElement : annotations) {
            if (typeElement.getQualifiedName().toString().equals("org.mule.api.annotations.Connector")) {
                connectorTypeElement = typeElement;
                continue;
            }
            if (!typeElement.getQualifiedName().toString().equals("org.mule.api.annotations.Processor")) continue;
            processorTypeElement = typeElement;
        }
        assert (connectorTypeElement == null) : "Failed to load the type element for org.mule.api.annotations.Connector";
        assert (processorTypeElement == null) : "Failed to load the type element for org.mule.api.annotations.Processor";
        try {
            this.logger.info((Object)"** Inspect Connector");
            ConnectorInspector inspectConnector = new ConnectorInspector(this.messager, this.environment);
            List<String> list = inspectConnector.inspectConnectors(connectorTypeElement);
            String connectorXmlFlow = list.get(0);
            List<ConnectorProcessorInfo> inspectedOperations = inspectConnector.inspectProcessors(processorTypeElement);
            this.logger.info((Object)"** Inspect Flows");
            MuleFlowInspector muleFlowInspector = new MuleFlowInspector(this.messager, this.environment, this.projectPath);
            List<FlowInfo> inspectedTestResourcesForFlowOperations = muleFlowInspector.inspectTestResourcesForFlowOperations(connectorTypeElement, connectorXmlFlow);
            this.logger.info((Object)"** Inspect Test Sources");
            TestSourcesInspector testSourcesInspector = new TestSourcesInspector(this.messager, this.environment, this.projectPath);
            List<TestSourceItemInfo> inspectedTestSourcesForCallsToFlows = testSourcesInspector.inspectTestSourcesForCallsToFlows(connectorTypeElement, connectorXmlFlow);
            this.logger.info((Object)"** Export Coverage Report");
            ConnectorAutomationCoverageReport connectorAutomationCoverageReport = new ConnectorAutomationCoverageReport(this.messager, this.projectPath);
            AutomationCoverageReport generatedReport = connectorAutomationCoverageReport.generateReport(inspectedOperations, inspectedTestResourcesForFlowOperations, inspectedTestSourcesForCallsToFlows);
            connectorAutomationCoverageReport.writeReport(generatedReport);
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        return true;
    }
}

