/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.automationtestcoverage.inspectors;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.mule.tools.automationtestcoverage.model.ConnectorProcessorInfo;
import org.mule.tools.automationtestcoverage.utils.Utils;

public class ConnectorInspector {
    private Messager messager;
    private RoundEnvironment environment;

    public ConnectorInspector(Messager messager, RoundEnvironment environment) {
        this.messager = messager;
        this.environment = environment;
    }

    public List<ConnectorProcessorInfo> inspectProcessors(TypeElement connectorAnnotationType) {
        LinkedList<ConnectorProcessorInfo> listConnectorProcessorInfo = new LinkedList<ConnectorProcessorInfo>();
        Set<? extends Element> elementsAnnotatedWith = this.environment.getElementsAnnotatedWith(connectorAnnotationType);
        if (elementsAnnotatedWith == null || elementsAnnotatedWith.isEmpty()) {
            Utils.throwError(this.messager, "Cannot locate any class annotated as @Connector");
        }
        for (Element element : elementsAnnotatedWith) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            listConnectorProcessorInfo.add(new ConnectorProcessorInfo(element.getSimpleName().toString()));
        }
        return listConnectorProcessorInfo;
    }

    public List<String> inspectConnectors(TypeElement connectorAnnotationType) {
        LinkedList<String> connectorPrefixes = new LinkedList<String>();
        Set<? extends Element> elementsAnnotatedWith = this.environment.getElementsAnnotatedWith(connectorAnnotationType);
        if (elementsAnnotatedWith == null || elementsAnnotatedWith.isEmpty()) {
            Utils.throwError(this.messager, "Cannot locate any class annotated as @Connector");
        }
        for (Element element : elementsAnnotatedWith) {
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!annotationMirror.getAnnotationType().equals(connectorAnnotationType.asType())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                for (ExecutableElement executableElement : elementValues.keySet()) {
                    if (!executableElement.getSimpleName().toString().equalsIgnoreCase("name")) continue;
                    AnnotationValue annotationValue = elementValues.get(executableElement);
                    connectorPrefixes.add(annotationValue.getValue().toString());
                }
            }
        }
        return connectorPrefixes;
    }
}

