/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.automationtestcoverage.inspectors;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.mule.tools.automationtestcoverage.model.FlowInfo;
import org.mule.tools.automationtestcoverage.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MuleFlowInspector {
    private static final String testResourcesRelativePath = "src/test/resources";
    private static FilenameFilter filter = null;
    private Messager messager;
    private Logger logger = Logger.getLogger(MuleFlowInspector.class);
    private RoundEnvironment environment;
    private String projectPath;

    private static synchronized FilenameFilter getFilterInstance() {
        if (filter == null) {
            filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(".xml");
                }
            };
        }
        return filter;
    }

    public MuleFlowInspector(Messager messager, RoundEnvironment environment, String projectPath) {
        this.messager = messager;
        this.environment = environment;
        this.projectPath = projectPath;
    }

    public List<FlowInfo> inspectTestResourcesForFlowOperations(TypeElement e, String connectorXmlPrefix) {
        LinkedList<FlowInfo> listFlowInfo = new LinkedList<FlowInfo>();
        File testResourcesFolder = new File(this.projectPath + testResourcesRelativePath);
        if (testResourcesFolder == null || !testResourcesFolder.isDirectory()) {
            Utils.throwError(this.messager, "Cannot locate test resources folder in " + this.projectPath + testResourcesRelativePath);
        }
        for (File f : testResourcesFolder.listFiles(MuleFlowInspector.getFilterInstance())) {
            this.logger.debug((Object)("Inspecting for flows in " + f.getAbsolutePath()));
            List<FlowInfo> inspectFileForFlows = null;
            try {
                inspectFileForFlows = MuleFlowInspector.inspectFileForFlows(f, connectorXmlPrefix);
                if (inspectFileForFlows == null || inspectFileForFlows.isEmpty()) continue;
                for (FlowInfo fi : inspectFileForFlows) {
                    listFlowInfo.add(fi);
                }
            }
            catch (RuntimeException ex) {
                Utils.throwError(this.messager, ex.getMessage());
            }
        }
        if (listFlowInfo.isEmpty()) {
            Utils.throwError(this.messager, "None of the inspected XML files had a Mule Flow defined");
        }
        return listFlowInfo;
    }

    public static List<FlowInfo> inspectFileForFlows(File muleFlowFile, String connectorXmlPrefix) {
        XPathExpression xPathExpression;
        XPath xpath;
        Document doc;
        LinkedList<FlowInfo> flowsInfo;
        block15: {
            flowsInfo = new LinkedList<FlowInfo>();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = null;
            try {
                dBuilder = dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Cannot generate document building for file:  " + muleFlowFile.getAbsolutePath(), e);
            }
            doc = null;
            try {
                doc = dBuilder.parse(muleFlowFile);
            }
            catch (SAXException e) {
                throw new RuntimeException("Cannot parse the document for file: " + muleFlowFile.getAbsolutePath(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot find the document building for file: " + muleFlowFile.getAbsolutePath(), e);
            }
            xpath = XPathFactory.newInstance().newXPath();
            xPathExpression = null;
            try {
                xPathExpression = xpath.compile("/mule/flow");
            }
            catch (XPathExpressionException e) {
                if ($assertionsDisabled) break block15;
                throw new AssertionError((Object)"The xpathExpression cannot be compiled");
            }
        }
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Cannot evaluate the document for file: " + muleFlowFile.getAbsolutePath(), e);
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        int xMax = nodeList.getLength();
        for (int x = 0; x < xMax; ++x) {
            FlowInfo flowInfo = new FlowInfo();
            Node item = nodeList.item(x);
            NamedNodeMap attributes = item.getAttributes();
            flowInfo.setFlowName(attributes.getNamedItem("name").getNodeValue());
            XPathExpression xPathExpression2 = null;
            NodeList muleNodes = null;
            try {
                xPathExpression2 = xpath.compile("*");
                muleNodes = (NodeList)xPathExpression2.evaluate(item, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("Cannot evaluate nodes inside flow with name " + flowInfo.getFlowName(), e);
            }
            Pattern muleOpPattern = Pattern.compile(connectorXmlPrefix + ":(.*)");
            if (muleNodes != null && muleNodes.getLength() > 0) {
                int yMax = muleNodes.getLength();
                for (int y = 0; y < yMax; ++y) {
                    Node muleNode = muleNodes.item(y);
                    Matcher muleOpMatcher = muleOpPattern.matcher(muleNode.getNodeName());
                    if (!muleOpMatcher.find()) continue;
                    flowInfo.addConnectorOperation(muleOpMatcher.group(1));
                }
            }
            flowsInfo.add(flowInfo);
        }
        return flowsInfo;
    }
}

