/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.automationtestcoverage.inspectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.apache.log4j.Logger;
import org.mule.tools.automationtestcoverage.model.TestSourceItemInfo;
import org.mule.tools.automationtestcoverage.utils.Utils;

public class TestSourcesInspector {
    private static final String testSourcesRelativePath = "src/test/java";
    private static final Pattern lookUpFlowPatter = Pattern.compile("lookupMessageProcessor\\(\"([^\"]+)\"\\)");
    private static final Pattern lookUpFlowPatter2 = Pattern.compile("runFlowAndGetPayload\\(\"([^\"]+)\"\\)");
    private static FilenameFilter filter = null;
    private Messager messager;
    private Logger logger = Logger.getLogger(TestSourcesInspector.class);
    private RoundEnvironment environment;
    private String projectPath;

    private static synchronized FilenameFilter getFilterInstance() {
        if (filter == null) {
            filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(".java");
                }
            };
        }
        return filter;
    }

    public TestSourcesInspector(Messager messager, RoundEnvironment environment, String projectPath) {
        this.messager = messager;
        this.environment = environment;
        this.projectPath = projectPath;
    }

    public List<TestSourceItemInfo> inspectTestSourcesForCallsToFlows(TypeElement e, String connectorXmlPrefix) {
        LinkedList<TestSourceItemInfo> listTestSourceItemInfo = new LinkedList<TestSourceItemInfo>();
        File testResourcesFolder = new File(this.projectPath + testSourcesRelativePath);
        if (testResourcesFolder == null || !testResourcesFolder.isDirectory()) {
            Utils.throwError(this.messager, "Cannot locate test resources folder in " + this.projectPath + testSourcesRelativePath);
        }
        this.recursiveInspectTestSources(e, connectorXmlPrefix, listTestSourceItemInfo, testResourcesFolder);
        return listTestSourceItemInfo;
    }

    public void recursiveInspectTestSources(TypeElement e, String connectorXmlPrefix, List<TestSourceItemInfo> listTestSourceItemInfo, File currentDirectory) {
        for (File f : currentDirectory.listFiles(TestSourcesInspector.getFilterInstance())) {
            this.logger.debug((Object)("Inspecting for java test sources in " + f.getAbsolutePath()));
            TestSourceItemInfo testSourceItemInfo = new TestSourceItemInfo(Utils.getRelativePath(this.projectPath, f.getAbsolutePath()));
            try {
                this.addOperationsInFileToTestSourceItemInfo(f, testSourceItemInfo);
                listTestSourceItemInfo.add(testSourceItemInfo);
            }
            catch (IOException e1) {
                Utils.throwError(this.messager, "Error during inspection for flowCalls in java file: " + f.getAbsolutePath());
            }
        }
        for (File f : currentDirectory.listFiles()) {
            if (!f.isDirectory()) continue;
            this.recursiveInspectTestSources(e, connectorXmlPrefix, listTestSourceItemInfo, f);
        }
    }

    public TestSourceItemInfo addOperationsInFileToTestSourceItemInfo(File inputFile, TestSourceItemInfo testSourceItemInfo) throws IOException {
        FileInputStream fis = new FileInputStream(inputFile);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
        String line = null;
        Matcher matcher = null;
        boolean parseNext = false;
        int bracketCount = 0;
        while ((line = br.readLine()) != null) {
            String flow;
            if (line.contains("@Test")) {
                parseNext = true;
                bracketCount = 0;
            } else if (parseNext && line.contains("{") && !line.contains("}")) {
                ++bracketCount;
            } else if (parseNext && line.contains("}") && !line.contains("{") && --bracketCount == 0) {
                parseNext = false;
            }
            if (!parseNext) continue;
            matcher = lookUpFlowPatter.matcher(line);
            if (matcher.find()) {
                flow = matcher.group(1);
                testSourceItemInfo.addFlowName(flow);
                continue;
            }
            matcher = lookUpFlowPatter2.matcher(line);
            if (!matcher.find()) continue;
            flow = matcher.group(1);
            testSourceItemInfo.addFlowName(flow);
        }
        br.close();
        return testSourceItemInfo;
    }
}

