/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.automationtestcoverage.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.tools.automationtestcoverage.model.AutomationCoverageReportItem;

public class AutomationCoverageReport {
    private List<AutomationCoverageReportItem> items = new LinkedList<AutomationCoverageReportItem>();
    private boolean automationPassed = true;
    private int operations;
    private int operationsCovered;
    private int operationsUncovered;
    private int operationsSkipped;

    public void addAutomationCoverageReportItem(AutomationCoverageReportItem item) {
        if (item != null) {
            this.items.add(item);
            ++this.operations;
            if (item.getSkippedOperation()) {
                ++this.operationsSkipped;
            } else if (item.getTestFilesCovered().isEmpty()) {
                ++this.operationsUncovered;
                this.automationPassed = false;
            } else {
                ++this.operationsCovered;
            }
        }
    }

    public List<AutomationCoverageReportItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public boolean getAutomationPassed() {
        return this.automationPassed;
    }

    public int getOperations() {
        return this.operations;
    }

    public int getOperationsCovered() {
        return this.operationsCovered;
    }

    public int getOperationsUncovered() {
        return this.operationsUncovered;
    }

    public int getOperationsSkipped() {
        return this.operationsSkipped;
    }
}

