/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.automationtestcoverage.model;

import java.util.LinkedList;
import java.util.List;
import org.mule.tools.automationtestcoverage.model.ConnectorProcessorInfo;

public class AutomationCoverageReportItem {
    private ConnectorProcessorInfo connectorOperationInfo;
    private List<String> testFilesCovered;
    private boolean skippedOperation;
    private boolean coveredOperation;
    private boolean missingAssertion;
    private String causeOfSkip;
    private String causeOfWarning;

    public AutomationCoverageReportItem(ConnectorProcessorInfo connectorOperationInfo) {
        this.connectorOperationInfo = connectorOperationInfo;
        this.testFilesCovered = new LinkedList<String>();
        this.skippedOperation = false;
        this.coveredOperation = false;
        this.missingAssertion = false;
    }

    public ConnectorProcessorInfo getConnectorOperationInfo() {
        return this.connectorOperationInfo;
    }

    public List<String> getTestFilesCovered() {
        return this.testFilesCovered;
    }

    public void setSkippedOperation(boolean skipOperation) {
        this.skippedOperation = skipOperation;
    }

    public boolean getSkippedOperation() {
        return this.skippedOperation;
    }

    public String getCauseOfSkip() {
        return this.causeOfSkip;
    }

    public void setCauseOfSkip(String causeOfSkip) {
        this.causeOfSkip = causeOfSkip;
    }

    public void setCauseOfWarning(String causeOfWarning) {
        this.causeOfWarning = causeOfWarning;
    }

    public String getCauseOfWarning() {
        return this.causeOfWarning;
    }

    public boolean isMissingAssertion() {
        return this.missingAssertion;
    }

    public void setMissingAssertion(boolean missingAssertion) {
        this.missingAssertion = missingAssertion;
    }

    public void addTestFileCovered(String filePath) {
        if (filePath != null && !filePath.isEmpty()) {
            this.testFilesCovered.add(filePath);
            this.coveredOperation = true;
        }
    }

    public void addTestFilesCovered(List<String> filesPath) {
        if (filesPath != null && !filesPath.isEmpty()) {
            for (String f : filesPath) {
                this.addTestFileCovered(f);
            }
        }
    }

    public boolean getCoveredOperation() {
        return this.coveredOperation;
    }
}

