/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.automationtestcoverage.utils;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class Utils {
    private static final Pattern camelCaseToMuleXmlPattern = Pattern.compile("([A-Z0-9])");
    private static final Pattern generatePathToProjectPathPattern = Pattern.compile("(.*)target/?.*");

    public static String transformCamelCaseToXmlName(String camelName) {
        if (camelName == null || camelName.isEmpty()) {
            return null;
        }
        Matcher matcher = camelCaseToMuleXmlPattern.matcher(camelName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "-" + matcher.group(1).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String transformGeneratePathToProjectPath(String generatePath) {
        String path = null;
        Matcher m = generatePathToProjectPathPattern.matcher(generatePath);
        if (m.find()) {
            path = m.group(1);
        }
        return path;
    }

    public static void throwError(Messager messager, String errorMsg) {
        messager.printMessage(Diagnostic.Kind.ERROR, errorMsg);
        throw new RuntimeException(errorMsg);
    }

    public static String getProjectPath(ProcessingEnvironment processingEnv) {
        String projectPath = null;
        try {
            FileObject resource2 = processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "temp", new Element[0]);
            File temp = new File(resource2.toUri().getPath());
            projectPath = Utils.transformGeneratePathToProjectPath(temp.getAbsolutePath());
            temp.delete();
        }
        catch (Throwable e1) {
            Utils.throwError(processingEnv.getMessager(), "Cannot locate the project path");
        }
        return projectPath;
    }

    public static String getRelativePath(String projectPath, String filePath) {
        return filePath.replace(projectPath, "");
    }
}

