/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.model.visitor;

import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.TransformerMethod;

public interface ModelVisitor {
    void visit(EnumType enumType);

    void visit(Method<?> method);

    void visit(Parameter<?> parameter);

    void visit(Type type);

    void visit(Field<?> field);

    void visit(Module module);

    void visit(ProcessorMethod processorMethod);

    void visit(SourceMethod sourceMethod);

    void visit(TransformerMethod transformerMethod);

    void visit(org.mule.devkit.model.Package pkg);

    boolean hasVisited(Identifiable<?> identifiable);

}
