/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.model;

import org.mule.devkit.model.module.factory.AnnotationProcessorFactory;

import java.lang.annotation.Annotation;
import java.util.List;

import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

/**
 * Regular Java Type
 */
public interface Type extends Identifiable<TypeElement>, Typeable {

    /**
     * Retrieves a list of methods annotated with {@code annotation} in the current module. This means that if the parent
     * of the current module has more methods with the same annotation, it will not be retrieved.
     *
     * @param annotation The annotation class to discriminate the methods
     * @return a list of methods (of type AnnotationProcessorMethodFactory) from the current module annotated with the parameter
     */
    List<Method<Type>> getMethodsAnnotatedWith(Class<? extends Annotation> annotation);

    Method getFirstMethodAnnotatedWith(Class<? extends Annotation> anAnnotation);

    /**
     * Retrieves a list of methods annotated with {@code annotation} from the current module, and any of it parents.
     *
     * @param annotation The annotation class to discriminate the methods
     * @return a complete list of methods (of type AnnotationProcessorMethodFactory) annotated with the parameter
     */
    <T> List<T> getRecursivelyAnnotationProcessorMethodsAnnotatedWith(Class<? extends Annotation> annotation);

    /**
     * Retrieves a list of methods annotated with {@code annotation} from the current module, and any of it parents.
     *
     * @param annotation The annotation class to discriminate the methods
     * @param factory a factory to instantiate AnnotationProcessors
     * @return a complete list of methods (of the type {@code factory} instantiates) annotated with the parameter {@code annotation}
     */
    <T> List<T> getRecursivelyMethodsAnnotatedWith(Class<? extends Annotation> annotation, AnnotationProcessorFactory factory) ;

    Method getRecursivelyFirstMethodAnnotatedWith(Class<? extends Annotation> anAnnotation);


    List<Field<Type>> getFields();

    /**
     * Get all methods defined in this class
     *
     * @return A list containing all the methods defined in this class
     */
    List<Method<Type>> getMethods();

    boolean hasNoArgConstructor();

    boolean isParametrized();

    boolean hasFieldAnnotatedWith(Class<? extends Annotation> annotation);

    /**
     * Returns the content of a field for a given annotation. Useful when the type of a {@code annotationField} within the
     * {@code anAnnotation} is Class or Class[]. Use:
     * <ul>
     *     <li> Annotation has a field type of: Class
     *         (DeclaredType) getAnnotationFieldValue(SomeAnnotation.class, "value")
     *     </li>
     *     <li> Annotation has a field type of: Class[]
     *         (List<AnnotationValue>) getAnnotationFieldValue(SomeAnnotation.class,"values")
     *     </li>
     * <ul/>
     */
    <T> T getAnnotationFieldValue(Class<? extends Annotation> anAnnotation, String annotationField);

    boolean isInterface();

    boolean isPrimitive();

    String getPathToSourceFile();

    org.mule.devkit.model.Package getPackage();

    String getClassName();

    Name getQualifiedName();

    String getPackageName();

    /**
     * Returns whether this type inherits from the provided class
     *
     * @param clazz class to validate inheritance
     * @return whether the type is subclass of the provided class or not
     */
    boolean inheritsFrom(Class clazz);

    /**
     * Returns whether this type inherits from the provided type
     *
     * @param type Type to validate inheritance
     * @return whether the type is subclass of the provided class or not
     */
    public boolean inheritsFrom(Type type);

    List<Field<Type>> getInheritedFields();

    Type getSuperClass();

    boolean hasSuperClass();

    boolean isDsqlQueryObject();
}
