/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.model.module.rest;

import org.mule.api.annotations.rest.HttpMethod;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.ProcessorMethod;

import java.util.List;

public interface RestCall extends ProcessorMethod {

    HttpMethod getRestNoun();

    String getContentType();

    String getUri();

    List<RestParameter> getUriParameters();

    List<RestParameter> getQueryParameters();

    List<RestParameter> getHeaderParameters();

    List<RestParameter> getPostParameters();

    RestParameter getPayloadParameter();

    Boolean payloadIsBinary();

    List<RestExceptionOn> getExceptions();

    RestTimeout getTimeout();
}
