package org.mule.devkit.model;

import java.util.List;


/**
 * The ClassType interface represents a class in Java that has been annotated with:
 * {@link org.mule.api.annotations.Module}, {@link org.mule.api.annotations.Connector} or {@link org.mule.api.annotations.ExpressionLanguage}.
 * or any annotation that lives within the package org.mule.api.annotations.components.*
 */
public interface ClassType extends Type {
    /**
     * Retrieve a list of fields that have been annotated with {@link javax.inject.Inject}
     * <p/>
     * This method will recursively go thru all superclasses as well.
     *
     * @return A list of all fields annotated with {@link javax.inject.Inject}
     */
    List<Field> getInjectFields();

    /**
     * Retrieve the method annotated with {@link org.mule.api.annotations.MetaDataKeyRetriever}
     *
     *
     * @return Method
     */
    Method getMetaDataKeyRetrieverMethod();

    /**
     * Retrieve the method annotated with {@link org.mule.api.annotations.MetaDataRetriever}
     *
     *
     * @return Method
     */
    Method getMetaDataRetrieverMethod();


    /**
     * Retrieve the method annotated with {@link org.mule.api.annotations.MetaDataOutputRetriever}
     *
     * @return Method
     */
    Method getMetaDataOutputRetrieverMethod();
}
