/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.model;

import javax.lang.model.element.VariableElement;

public interface Variable<P extends Identifiable> extends Identifiable<VariableElement>, Parentable<P> {

    /**
     * Returns the fully qualified name of the underlying variable.
     */
    String getJavaType();

    /**
     * Whether the given element is marked as optional
     */
    boolean isOptional();

    /**
     * Whether the given element has a size limit
     */
    boolean hasSizeLimit();

    /**
     * Whether the given element has pattern
     */
    boolean hasPattern();

    /**
     * Returns the pattern
     */
    String getPattern();

    /**
     * Returns the min size limit value
     */
    int getMinSizeLimit();

    /**
     * Returns the max size limit value
     */
    int getMaxSizeLimit();


    /**
     * Whether the given element is has a default value
     */
    boolean hasDefaultValue();

    /**
     * Returns the given element's default value
     */
    String getDefaultValue();

    /**
     * Returns true if the variable is annotated with {@link org.mule.api.annotations.display.Text}
     */
    boolean isText();

    /**
     * Alternative name of the attribute to be generated
     */
    String getAlternativeName();

    /**
     * The variable can be passed by reference only.
     */
    boolean isRefOnly();

    /**
     * Whether the given element is has a default value
     */
    boolean hasEmailPattern();

    /**
     * Returns the email domain if one configured otherwise empty domain
     */

    String getEmailDomain();

    /**
     * Whether the email has an default domain or not
     */

    boolean hasDefaultEmailDomain();

    /**
     * If the variable is annotated with {@link org.mule.api.annotations.param.MetaDataKeyParam}
     */
    boolean isMetaDataKey();

    /**
     * If the variable is annotated with {@link org.mule.api.annotations.param.MetaDataStaticKey}
     */
    boolean isMetaDataStaticKey();

    /**
     * If the variable is annotated with {@link org.mule.api.annotations.Query}
     */
    boolean isQuery();
}
