package org.mule.devkit.model.module.components.connection;


import com.google.common.base.Optional;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.components.Component;

import java.util.List;

/**
 */
public interface ConnectionComponent extends Component {
    /**
     * @return The name of the config/global element, which values usually are "config" or "config-with-oauth"
     */
    String configElementName();

    /**
     * @return the friendly name for current strategy that will be used in the Studio dialog
     */
    String friendlyName();

    /**
     * @return The fields annotated with {@link org.mule.api.annotations.Configurable} for the current component
     */
    List<Field> getConfigurableFields();

    /**
     * @return The method annotated with {@link org.mule.api.annotations.TestConnectivity} if the flag
     *  {@link org.mule.api.annotations.TestConnectivity#active()} is set to true, {@link com.google.common.base.Optional#absent()} otherwise
     */
    Optional<Method> testConnectivityMethod();
}
