package org.mule.devkit.model.module.connectivity;

import org.mule.devkit.model.Method;

/**
 * Represents the common behaviour of connection management (4 annotated methods)
 */
public interface ConnectionManagementCapability {
    /**
     * @return Method annotated with {@link org.mule.api.annotations.Connect}
     */
    ConnectMethod getConnectMethod();

    /**
     * @return Method annotated with {@link org.mule.api.annotations.Disconnect}
     */
    Method<ManagedConnectionModule> getDisconnectMethod();

    /**
     * @return Method annotated with {@link org.mule.api.annotations.ValidateConnection}
     */
    Method<ManagedConnectionModule> getValidateConnectionMethod();

    /**
     * @return Method annotated with {@link org.mule.api.annotations.ConnectionIdentifier}
     */
    Method<ManagedConnectionModule> getConnectionIdentifierMethod();
}
