/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.module.components.metadatacategory;

import com.google.common.base.Optional;
import org.mule.devkit.model.Accessible;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.components.ModuleComponent;
import org.mule.devkit.model.module.components.ProcessorComponent;

import javax.lang.model.element.Name;
import java.lang.annotation.Annotation;
import java.util.List;

public interface MetaDataCategoryComponent extends ModuleComponent, ProcessorComponent, Accessible {

    Optional<Field> getInjectedConnector();

    String getMetaDataKeySeparator();

    Method getMetaDataKeyRetrieverMethod();

    Method getMetaDataRetrieverMethod();

    Method getMetaDataOutputRetrieverMethod();

    Optional<Method> getMetaDataNativeQueryOutputRetriever();

    boolean isMultiLevelCategory();

    /**
     * see {@link Type#hasNoArgConstructor()}
     */
    boolean hasNoArgConstructor();

    /**
     * see {@link Type#getQualifiedName()}
     */
    Name getQualifiedName();

    /**
     * see {@link Type#getMethodsAnnotatedWith(Class)}
     */
    List<Method<Type>> getMethodsAnnotatedWith(Class<? extends Annotation> annotation);
}
