/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.model;

import org.mule.devkit.model.visitor.ModelVisitor;

import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public interface Identifiable<T extends Element> extends Annotable, Documentable, Accessible, Generifiable {
    T unwrap();

    TypeMirror asTypeMirror();

    Type asType();

    String getName();

    /**
     * Returns whether the variable name is a reserved identifier or not
     */
    boolean isReservedIdentifier();

    void accept(ModelVisitor visitor);
}
