/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.module.connectivity;

import com.google.common.base.Optional;
import org.mule.devkit.model.Method;

/**
 * Represents the common behaviour of connection management (4 annotated methods)
 */
public interface ConnectionManagementCapability {
    /**
     * @return Method annotated with {@link org.mule.api.annotations.Connect}
     */
    ConnectMethod getConnectMethod();

    /**
     * @return Method annotated with {@link org.mule.api.annotations.Disconnect}
     */
    Method<ManagedConnectionModule> getDisconnectMethod();

    /**
     * @return Method annotated with {@link org.mule.api.annotations.ValidateConnection}
     */
    Method<ManagedConnectionModule> getValidateConnectionMethod();

    /**
     * @return Method annotated with {@link org.mule.api.annotations.ConnectionIdentifier}
     */
    Optional<Method<ManagedConnectionModule>> getConnectionIdentifierMethod();
}
