/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.model;

public interface Parameter<P extends Method> extends Variable<P> {
    boolean shouldBeIgnored();

    /**
     * @return true only if the parameter must not be shown in Studio as it might be feeded automatically by devkit (e.g. MuleEvent),
     * or when it's a container type (e.g.: NestedProcessor or List<NestedProcessor>)
     */
    boolean shouldBeUIIgnored();

    GenericType getGenericType();

    boolean isQuery();

    boolean isQueryPart();

    /**
     * If the variable is annotated with {@link org.mule.api.annotations.param.Payload} or the given element has default value equals to #[payload]
     */
    boolean hasDefaultPayload();

}