/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.devkit.model.module;

import org.mule.api.annotations.SourceStrategy;
import org.mule.api.annotations.SourceThreadingModel;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;

import javax.lang.model.element.AnnotationValue;
import java.util.List;

public interface SourceMethod extends Method<Type> {
    boolean shouldRunOnPrimaryNodeOnly();

    SourceThreadingModel getThreadingModel();

    SourceStrategy getSourceStrategy();

    List<AnnotationValue> reconnectOn();

    Long getPollingPeriod();

    boolean isPolling();
}
