/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.module;

import com.google.common.base.Optional;
import org.mule.api.annotations.Paged;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.components.managers.ProcessorComponentManager;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.DeclaredType;
import java.lang.annotation.Annotation;
import java.util.List;

public interface ProcessorMethod extends Method<Type> {

    /**
     * Returns the {@link org.mule.devkit.model.module.components.ProcessorComponent} manager
     */
    ProcessorComponentManager manager();

    Module module();

    /**
     * Use {@link #reconnectOn()} instead
     */
    @Deprecated
    DeclaredType invalidateConnectionOn();

    /**
     * Use {@link #reconnectOn()} instead
     */
    @Deprecated
    DeclaredType invalidateAccessTokenOn();

    List<AnnotationValue> reconnectOn();

    DeclaredType metaDataScope();

    Optional<MetaDataCategoryComponent> getMetaDataCategoryComponent();

    /**
     * Returns the content of a field for a given annotation. Useful when the type of a {@code annotationField} within the
     * {@code anAnnotation} is Class or Class[]. Use:
     * <ul>
     *     <li> Annotation has a field type of: Class
     *         (DeclaredType) getAnnotationFieldValue(SomeAnnotation.class, "value")
     *     </li>
     *     <li> Annotation has a field type of: Class[]
     *         (List<AnnotationValue>) getAnnotationFieldValue(SomeAnnotation.class,"values")
     *     </li>
     * <ul/>
     */
    <T> T getAnnotationFieldValue(Class<? extends Annotation> anAnnotation, String annotationField);

    boolean isIntercepting();

    boolean isOAuthProtected();

    public boolean canBeUsedInConnectionManagement();

    public ManagedConnectionModule getManagedConnectionModule();

    /**
     * This is currently a hack to find if the current processor lives in a module with oauth support, or if any subclass
     * has oauth support.
     *
     * @return
     */
    @Deprecated
    public boolean canBeUsedInOAuthManagement();

    /**
     * This is currently a hack to find if the current processor lives in a module with oauth support, or if any subclass
     * has oauth support.
     *
     * @return
     */
    @Deprecated
    public OAuthModule getOAuthModule();

    boolean hasQuery();

    Parameter getQueryParameter();

    boolean hasQueryParts();

    boolean hasQueryTranslator();

    public boolean isPaged();

    public boolean isBatch();

    public Paged getPagingAnnotation();

    /**
     * Returns true only if the current processor (1) module's minMuleVersion is higher than 3.4.x and
     * (2) the current processor has not been annotated with {@link org.mule.api.annotations.NoMetaData}
     *
     * @return true if the processor supports dynamic datasense, false otherwise.
     */
    boolean hasDynamicMetaData();

    /**
     * <p>Returns true only if the current processor {@link #hasDynamicMetaData()} is true, and it has input or output
     * metadata.</p>
     * <p>This method is used instead of {@link #hasDynamicMetaData()} if we want to be 100% sure that the
     * current processor actually hast something being affected by the {@link MetaDataKeyParam}</p>
     *
     * @return true if the processor supports dynamic datasense, false otherwise.
     */
    boolean hasInputOrOutputDynamicMetaData();

    boolean hasDynamicInputMetadata();

    boolean hasDynamicOutputMetaData();

    Parameter getInputMetaDataKeyParameter();

    Parameter getOutputMetaDataKeyParameter();

    boolean hasStaticKeyMetaData();

    boolean hasStaticKeyInputMetaData();

    Parameter getStaticKeyInputMetaData();

    boolean hasStaticKeyOutputMetaData();

    MetaDataStaticKey getStaticKeyOutputMetaData();

    boolean hasMetaDataScope();

    Optional<DeclaredType> getExceptionHandler();

    boolean isContainer();

    boolean isContainerList();
}
