/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.module.components.connection;

import com.google.common.base.Optional;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Type;

/**
 * Represents a component that has been annotated with @HttpBasicAuth
 */
public interface HttpBasicAuthComponent extends ConnectionComponent, Type {
    /**
     * @return value of the header that is going to be added on each call to the server
     */
    String headerName();

    /**
     * @return concrete username that has been fed to the current global-element
     */
    Field username();

    /**
     * @return concrete password that has been fed to the current global-element if exists,
     * {@link com.google.common.base.Absent} otherwise (a password might not bee needed)
     */
    Optional<Field> password();

    /**
     * @return the prefix that will be used before the encoding of username:password.
     */
    String prefix();
}
