/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.module.components.connection;

import com.google.common.base.Optional;
import org.mule.api.annotations.ws.WsdlBodyEnricher;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;

import java.util.List;

public interface WsdlProviderComponent extends ConnectionManagementCapability, ConnectionComponent, Type  {

    /**
     * @return Method annotated with {@link org.mule.api.annotations.ws.WsdlServiceRetriever}
     */
    Method wsdlServiceRetrieverMethod();

    /**
     * @return Method annotated with {@link org.mule.api.annotations.ws.WsdlServiceEndpoint}
     */
    Method wsdlServiceEndpointMethod();

    /**
     * @return The string that will be used to split keys in the XML file
     */
    String keySeparator();

    /**
     * @return The labels to name each key dropdown, given in order.
     */
    List<String> keyLabels();

    /**
     * @return The labels to name each key dropdown, given as csv and in key order.
     */
    String plainedKeyLabels();

    /**
     * @return The method annotated with {@link org.mule.api.annotations.ws.WsdlSecurity} if has been used,
     * {@link com.google.common.base.Optional#absent()} otherwise
     */
    Optional<Method> wsdlSecurityResolver();

    /**
     * @return The method annotated with {@link org.mule.api.annotations.ws.WsdlTransportRetriever} if has been used,
     * {@link com.google.common.base.Optional#absent()} otherwise
     */
    Optional<Method> wsdlTransportResolver();

    /**
     * @return The method annotated with {@link org.mule.api.annotations.ws.WsdlHeaders} if has been used,
     * {@link com.google.common.base.Optional#absent()} otherwise
     */
    Optional<Method> wsdlHeadersResolver();

    /**
     * @return The method annotated with {@link WsdlBodyEnricher} if has been used,
     * {@link com.google.common.base.Optional#absent()} otherwise
     */
    Optional<Method> wsdlBodyEnricher();

    /**
     * @return true when {@link org.mule.api.annotations.ws.WsdlServiceRetriever} returns a collection of
     * {@link org.mule.devkit.api.ws.definition.ServiceDefinition}, false otherwise
     */
    boolean hasMultipleServiceDefinition();

    boolean hasConnectionManagement();
    
}
