/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.api.annotations.display;

import java.lang.annotation.*;

/**
 * Used in {@link org.mule.api.annotations.Module} and {@link org.mule.api.annotations.Connector} annotated classes
 * to associate icons with them. Provided values are relative the annotated type location. If values are not provided
 * then {@link this#GENERIC_CLOUD_CONNECTOR_LARGE}, {@link this#GENERIC_CLOUD_CONNECTOR_SMALL},
 * {@link this#GENERIC_ENDPOINT_LARGE}, {@link this#GENERIC_ENDPOINT_SMALL}, {@link this#GENERIC_TRANSFORMER_LARGE} and
 * {@link this#GENERIC_TRANSFORMER_SMALL} will be used as needed formatting the strings with
 * {@link org.mule.api.annotations.Module#name()} or {@link org.mule.api.annotations.Connector#name()}
 */
@Target(ElementType.TYPE)
@Documented
@Retention(RetentionPolicy.SOURCE)
public @interface Icons {

    String GENERIC_CLOUD_CONNECTOR_SMALL = "../../../icons/%s-connector-24x16.png";
    String GENERIC_CLOUD_CONNECTOR_LARGE = "../../../icons/%s-connector-48x32.png";
    String GENERIC_TRANSFORMER_SMALL = "../../../icons/%s-transformer-24x16.png";
    String GENERIC_TRANSFORMER_LARGE = "../../../icons/%s-transformer-48x32.png";
    String GENERIC_ENDPOINT_SMALL = "../../../icons/%s-endpoint-24x16.png";
    String GENERIC_ENDPOINT_LARGE = "../../../icons/%s-endpoint-48x32.png";

    String connectorSmall() default GENERIC_CLOUD_CONNECTOR_SMALL;

    String connectorLarge() default GENERIC_CLOUD_CONNECTOR_LARGE;

    String transformerSmall() default GENERIC_TRANSFORMER_SMALL;

    String transformerLarge() default GENERIC_TRANSFORMER_LARGE;

    String endpointSmall() default GENERIC_ENDPOINT_SMALL;

    String endpointLarge() default GENERIC_ENDPOINT_LARGE;
}