/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.api.annotations.display;

import java.lang.annotation.*;

/**
 * Identifies a parameter a being large text input. This marker will generate a child element
 * instead of an attribute for the schema generation, but it will also use a text area
 * instead of a text field in the Studio dialog generation.
 */
@Target({ElementType.PARAMETER, ElementType.FIELD})
@Documented
@Retention(RetentionPolicy.SOURCE)
public @interface Text {
}