/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation defines a class that will export its functionality as a Mule module.
 * <p/>
 * There are a few restrictions as to which types as valid for this annotation:
 * - It cannot be an interface
 * - It must be public
 * - It cannot have a typed parameter (no generic)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Module {
    /**
     * The name of the module.
     */
    String name();

    /**
     * The version of the module. Defaults to 1.0.
     */
    String schemaVersion() default DEFAULT_VERSION;

    /**
     * Namespace of the module
     */
    String namespace() default "";

    /**
     * Location URI for the schema
     */
    String schemaLocation() default "";

    /**
     * Defined the module itself as being poolable
     */
    boolean poolable() default false;

    /**
     * Minimum Mule version required
     */
    String minMuleVersion() default "3.2";

    /**
     * Provides a friendly name for the module.
     */
    String friendlyName() default "";

    /**
     * Name of the configuration element
     */
    String configElementName() default "config";

    /**
     * Short description about the annotated module.
     */
    String description() default "";

    String DEFAULT_VERSION = "1.0";

    /**
     * Whether connectivity testing is enabled or not in this connector
     */
    ConnectivityTesting connectivityTesting() default ConnectivityTesting.OFF;

    /**
     * Whether metadata is enable or not in this connector
     */

    MetaDataSwitch metaData() default MetaDataSwitch.OFF;

}