/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.api.annotations.display;

import java.lang.annotation.*;

/**
 * Allows to specify a better label to the element and/or field to be used in Studio editor.
 *
 */
@Target({ElementType.PARAMETER, ElementType.FIELD})
@Documented
@Retention(RetentionPolicy.SOURCE)
public @interface FriendlyName {

    /**
     * The value is a short name for the annotated element. If this value is not specified it will
     * inferred from the annotated element name.
     */
    String value() default "";
}